package com.biz.eisp.base.importer.iterator;

import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.importer.DataField;
import com.biz.eisp.base.utils.DateUtils;
import com.biz.eisp.mdm.dict.util.DictUtil;

import jxl.Cell;
import jxl.Sheet;
import jxl.Workbook;

public class ExcelDataIterator implements DataIterator {
	private Sheet sheet;
	private int rows = -1;
	private int index;
	private List<DataField> dataFieldList;

	public ExcelDataIterator(InputStream is, int sheetIndex, List<DataField> dataFieldList) throws Exception {
		this.sheet = Workbook.getWorkbook(is).getSheet(sheetIndex);
		this.rows = this.sheet.getRows();
//		verifySheetRowsNum();
		this.index = 0;
		this.dataFieldList=dataFieldList;
	}

	/**
	 * 验证表格行数，换行符过滤
	 * @author wanglr
	 */
	private void verifySheetRowsNum() {
		for (int i = 0; i<this.sheet.getRows(); i++) {
			int isEmptyCount = 0;
			for (Cell cc : this.sheet.getRow(i)) {
				if (cc.getContents() == "") {
					++isEmptyCount;
				}
			}
			if (isEmptyCount == this.sheet.getRow(i).length) {
				--this.rows;
			}
		}
	}

	public ExcelDataIterator(InputStream is) throws Exception {
		this(is, 0,null);
	}

	public boolean hasNext() {
		return this.index < this.rows;
	}

	public Map<String, Object> next() {
		Cell[] cells = this.sheet.getRow(this.index++);
		Map<String,Object> rowMap = new HashMap<String,Object>();
		for (int m = 0; m < cells.length; m++) {
			String value=cells[m].getContents().trim();
			if(dataFieldList.size()>m){
				DataField dataField=dataFieldList.get(m);
				String code=dataField.getCode();
				if(StringUtil.isNotEmpty(value)&&dataField!=null
						&&StringUtil.isNotEmpty(dataField.getDictCode())){
					String dictCode=dataField.getDictCode();
					String valueStr=DictUtil.getDictCodeByValue(dictCode, value);
					if(StringUtil.isNotEmpty(valueStr)){
						value=valueStr;
					}
				}
				if(StringUtil.isNotEmpty(dataField.getFormat())){
					boolean flag=false;
					if(dataField.getFormat().length()>10){
						flag=DateUtils.isValidDateTime(value);
					}else if(dataField.getFormat().length()>7){
						flag=DateUtils.isValidDate(value);
					}else{
						flag=DateUtils.isValidMoth(value);
					}
					if(flag){
						rowMap.put(code, DateUtils.parse(value,dataField.getFormat()));
					}else{
						rowMap.put(code, value);
					}
				}else{
					rowMap.put(code, value);
				}
			}
		}
		return rowMap;
	} 

	public void remove() {
	}

	public int getIndex() {
		return this.index;
	}

	public int getRowNumber() {
		return this.index;
	}

	public int getSize() {
		return this.rows;
	}
}
