package com.biz.eisp.base.importer.validator;

import java.util.regex.Pattern;

import org.apache.commons.lang.StringUtils;

import com.biz.eisp.base.importer.DataField;


abstract class AbstractValidator implements DataValidator {
	protected String name;
	protected int length;
	protected boolean required;
	protected Pattern mask;
	protected String value;
	protected Object result;
	protected boolean valueIsBlank;

	public AbstractValidator(DataField field) {
		this.name = field.getTitle();
		this.length = field.getLength();
		this.required = field.isRequired();
		if (StringUtils.isNotBlank(field.getMask()))
			this.mask = Pattern.compile(field.getMask());
	}
	
	protected boolean validateRequired() {
		return (!this.required) || (!this.valueIsBlank);
	}

	protected boolean validateLength() {
		return (this.valueIsBlank)
				|| (this.value.length() <= this.length);
	}

	protected boolean validateMask() {
		return (this.valueIsBlank) || (this.mask == null)
				|| (this.mask.matcher(this.value).matches());
	}

	public Object validate(String value) throws ValidateException {
		this.result = null;
		this.value = value;
		this.valueIsBlank = StringUtils.isBlank(value);

		if (!validateRequired()) {
			throw new ValidateException("数据验证错误 : " + this.name
					+ " 必填");
		}
		if (!validateLength()) {
			throw new ValidateException("数据验证错误 : " + this.name
					+ " 最大长度是 " + this.length);
		}
		if (!validateMask()) {
			throw new ValidateException("数据验证错误 : " + this.name
					+ " 格式错误（不能通过正则表达式）");
		}
		if (!validateFormat()) {
			throw new ValidateException("数据验证错误 : " + this.name
					+ " 非法格式");
		}
		return this.result == null ? value : this.result;
	}

	protected abstract boolean validateFormat();
}