package com.biz.eisp.base.importer.validator;

import java.text.DecimalFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.commons.lang.StringUtils;

import com.biz.eisp.base.importer.DataField;

class NumberValidator extends AbstractValidator {
	private DecimalFormat numberFormat;

	public NumberValidator(DataField field) {
		super(field);
		String format = field.getFormat();
		if (StringUtils.isBlank(format)) {
			format = "0.0";
		}
		this.numberFormat = new DecimalFormat(format);
	}

	protected boolean validateFormat() {
		if (!this.valueIsBlank)
			try {
				if(isInteger(this.value)){
					this.result = Integer.parseInt(this.value);
				}else{
					this.value = this.numberFormat.format(new Double(this.value));
					if (this.value.indexOf(".") != -1) {
						this.result = new Double(this.value);
					} else {
						this.result = new Long(this.value);
					}
				}
				return true;
			} catch (Exception e) {
				return false;
			}
		return true;
	}
	
	/*** 
     * 判断 String 是否是 int 
     * @param input 
     * @return 
     */  
    public static boolean isInteger(String input){  
        Matcher mer = Pattern.compile("^[+-]?[0-9]+$").matcher(input);  
        return mer.find();  
    }  
}