package com.biz.eisp.base.importer.validator;

import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.importer.DataField;
import com.biz.eisp.mdm.config.entity.TmMdmTableConfigEntity;
import com.biz.eisp.mdm.dict.util.DictUtil;
import com.biz.eisp.mdm.dict.vo.TmDictDataVo;

import java.util.List;
import java.util.regex.Pattern;

public class ValidatorFactory {
	public static DataValidator createValidator(DataField field) {
		DataValidator v = null;
		if ("char".equals(field.getType().trim())) {
			v = new CharValidator(field);
		} else if ("date".equals(field.getType().trim())) {
			v = new DateValidator(field);
		} else if ("number".equals(field.getType().trim())) {
			v = new NumberValidator(field);
		}
		return v;
	}
	
	/**
	 * 验证动态表单配置
	 * @param tableConfigEntity 包含字段名称和表单排序
	 * @param fieldValue 导入字段值
	 * @return
	 */
	public static String validateDynamicImplData(TmMdmTableConfigEntity tableConfigEntity,Object fieldValue){
		String errorMsg="";
		String fieldDesc="";
		String maskStr="";
		boolean required=false;
		String dict="";
		if(tableConfigEntity!=null){
			//获取数据验证信息
			maskStr=tableConfigEntity.getDataType();
			//字段描述
			fieldDesc=StringUtil.isNotEmpty(tableConfigEntity.getFormName())?
					tableConfigEntity.getFormName():tableConfigEntity.getColumnDesc();
			if(tableConfigEntity.getRequired()!=null
					&&tableConfigEntity.getRequired()==1){
				required=true;
			}
			dict=tableConfigEntity.getDictType();
		}
		//表单验证校验
		if(StringUtil.isNotEmpty(fieldValue)){
			if(StringUtil.isNotEmpty(maskStr)){
				String validateMsg=ValidatorFactory.validateForm(fieldValue, maskStr);
				if(StringUtil.isNotEmpty(validateMsg)){
					errorMsg= fieldDesc+validateMsg;
				}
			}
		}else{
			//必填字段为空
			if(required){
				errorMsg= fieldDesc+"为空";
			}
		}
		
		//数据字典校验
		if(StringUtil.isNotEmpty(dict)&&StringUtil.isNotEmpty(fieldValue)){
			String code=DictUtil.getDictDataValueByCode(dict, fieldValue.toString());
			List<TmDictDataVo> dataList=DictUtil.getDictList(dict);
			if(CollectionUtil.listNotEmptyNotSizeZero(dataList)){
				if(StringUtil.isEmpty(code)){
					errorMsg+=fieldDesc+"输入有误，数据字典["+dict+"]未找到值"+fieldValue;
				}
			}else{
				errorMsg+="未找到数据字典"+dict;
			}
			
		}
		
		return errorMsg;
	}
	
	/**
	 * 仿页面form表单验证
	 * @param value 数据值
	 * @param maskStr 验证表达式
	 * @return
	 */
	public static String validateForm(Object value,String maskStr){
		String content="";
		if(StringUtil.equals(maskStr, "*")){
			if(StringUtil.isEmpty(value)){
				content="验证失败，不能为空";
			}
		}else if(StringUtil.equals(maskStr, "n")){
			String numMask="^[0-9]*$";
			if(!validateMask(value.toString(), numMask)){
				content="验证失败，数据应为数值";
			}
		}else{
			maskStr=maskStr.substring(1, maskStr.length()-1);
			if(!validateMask(value.toString(), maskStr)){
				content="验证失败，不能通过主数据配置表单验证";
			}
		}
		return content;
	}
	
	
	
	private static boolean validateMask(String value,String maskStr) {
		Pattern mask=Pattern.compile(maskStr);
		return (mask == null)
				|| (mask.matcher(value).matches());
	}
}
