package com.biz.eisp.base.interfacedao.factory;

import java.lang.annotation.Annotation;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.util.StringUtils;

import com.biz.eisp.base.interfacedao.annotation.InterfaceDao;
import com.biz.eisp.base.interfacedao.aop.InterfaceDaoHandler;
import com.biz.eisp.base.interfacedao.interceptor.EmptyInterceptor;

/**
 * 扫描配置文件
 * @author Sean
 */
public class InterfaceDaoBeanScannerConfigurer  implements BeanDefinitionRegistryPostProcessor {

	//需扫描的包
	private String basePackage;
	
	//默认是IDao,推荐使用Repository
	private Class<? extends  Annotation> annotation=InterfaceDao.class;
	
	//Map key类型
	private String keyType = "origin";
	
	//格式化sql
	private boolean formatSql = false;
	
	//输出sql
	private boolean showSql = false;
	
	//数据库类型
	private String dbType;
	
	 //拦截器
	private EmptyInterceptor emptyInterceptor;
	

	@Override
	public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
		 //注册代理类
		registerRequestProxyHandler(registry);
		InterfaceDaoClassPathMapperScanner scanner=
				new InterfaceDaoClassPathMapperScanner(registry, annotation);
		//加载Dao层接口
		scanner.scan(StringUtils.tokenizeToStringArray(this.basePackage, 
				ConfigurableApplicationContext.CONFIG_LOCATION_DELIMITERS));
	}
	
	@Override
	public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {}

	/**
	 * 手动注册interfaceDaoHandler Bean
	 * @param registry
	 */
	private void registerRequestProxyHandler(BeanDefinitionRegistry registry) {
		GenericBeanDefinition proxyBeanDefinition=new GenericBeanDefinition();
		proxyBeanDefinition.setBeanClass(InterfaceDaoHandler.class);
		proxyBeanDefinition.getPropertyValues().add("formatSql", formatSql);
		proxyBeanDefinition.getPropertyValues().add("showSql", showSql);
		proxyBeanDefinition.getPropertyValues().add("dbType", dbType);
		proxyBeanDefinition.getPropertyValues().add("keyType", keyType);
		proxyBeanDefinition.getPropertyValues().add("emptyInterceptor", emptyInterceptor);
		registry.registerBeanDefinition("interfaceDaoHandler", proxyBeanDefinition);
	}

	public String getBasePackage() {
		return basePackage;
	}

	public void setBasePackage(String basePackage) {
		this.basePackage = basePackage;
	}

	public Class<? extends Annotation> getAnnotation() {
		return annotation;
	}

	public void setAnnotation(Class<? extends Annotation> annotation) {
		this.annotation = annotation;
	}

	public String getKeyType() {
		return keyType;
	}

	public void setKeyType(String keyType) {
		this.keyType = keyType;
	}

	public boolean isFormatSql() {
		return formatSql;
	}

	public void setFormatSql(boolean formatSql) {
		this.formatSql = formatSql;
	}

	public boolean isShowSql() {
		return showSql;
	}

	public void setShowSql(boolean showSql) {
		this.showSql = showSql;
	}

	public String getDbType() {
		return dbType;
	}

	public void setDbType(String dbType) {
		this.dbType = dbType;
	}

	public EmptyInterceptor getEmptyInterceptor() {
		return emptyInterceptor;
	}

	public void setEmptyInterceptor(EmptyInterceptor emptyInterceptor) {
		this.emptyInterceptor = emptyInterceptor;
	}
	
	
}
