package com.biz.eisp.base.interfacedao.interceptor;

import java.lang.reflect.Field;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import com.biz.eisp.base.common.util.ResourceConfigUtils;

/**
 * 添加默认字段拦截器
 * @author Sean
 *
 */
public class InterfaceDaoInterceptor implements EmptyInterceptor {

	/**
	 * 追加新增字段
	 */
	@Override
	public boolean onInsert(Field[] fields, Object obj) {
		Map<Object, Object> map = new HashMap<Object, Object>();
		for(int i=0;i<fields.length;i++){
			fields[i].setAccessible(true);
			String fieldName=fields[i].getName();
			if ("createName".equals(fieldName)) {
				map.put("createName", ResourceConfigUtils.getSessionUserName().getUserName());
			}
			if ("createDate".equals(fieldName)) {
				map.put("createDate", new Date());
			}
		}
		return false;
	}

	/**
	 * 追加修改字段
	 */
	@Override
	public boolean onUpdate(Field[] fields, Object obj) {
		Map<Object, Object> map = new HashMap<Object, Object>();
		for(int i=0;i<fields.length;i++){
			fields[i].setAccessible(true);
			String fieldName=fields[i].getName();
			if ("updateName".equals(fieldName)) {
				map.put("updateName", ResourceConfigUtils.getSessionUserName().getUserName());
			}
			if ("updateDate".equals(fieldName)) {
				map.put("updateDate", new Date());
			}
		}
		return false;
	}

	

}
