package com.biz.eisp.base.progress.controller;

import javax.servlet.http.HttpServletRequest;

import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.core.web.BaseController;
import com.biz.eisp.base.progress.vo.ProgressInfo;

/**
 * 进度条轮询Controller
 * @author liukai
 *
 */
@Scope("prototype")
@Controller
@RequestMapping("/progressController")
public class ProgressController extends BaseController {
	
	/**
	 * 跳转到进度条页面
	 * @param request
	 * @param functionKey
	 * @return
	 */
	@RequestMapping(value = "goProgressForm", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goProgressForm(HttpServletRequest request, String functionKey) {
		return new ModelAndView("progress/progress");
	}
	
	/**
	 * 获取进度条信息
	 * @param request
	 * @param functionKey
	 * @return
	 */
	@ResponseBody
	@RequestMapping(value = "getProgress", method = {RequestMethod.GET, RequestMethod.POST})
	public AjaxJson getProgress(HttpServletRequest request, String functionKey) {
		AjaxJson j = new AjaxJson();
		j.setSuccess(true);
		
		if(functionKey == null) {
			functionKey = "default";
		}
		
		Object obj = request.getSession().getAttribute(functionKey + "_progressStatus");
		if(obj != null) {
			ProgressInfo progressInfo = (ProgressInfo)obj;
			j.setObj(progressInfo);
			
			//进度完成后，从Session中移除条对象信息进度
			if(progressInfo.isFinish()) {
				request.getSession().removeAttribute(functionKey + "_progressStatus");
			}
		}
		return j;
	}
}
