package com.biz.eisp.base.progress.controller;

import javax.servlet.http.HttpServletRequest;

import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.core.web.BaseController;
import com.biz.eisp.base.progress.listener.EispProgressListener;
import com.biz.eisp.base.progress.vo.ProgressInfo;

@Scope("prototype")
@Controller
@RequestMapping("/testProgressController")
public class TestProgressController extends BaseController {

	@ResponseBody
	@RequestMapping(value = "testProgress", method = {RequestMethod.GET, RequestMethod.POST})
	public AjaxJson testProgress(HttpServletRequest request, String functionKey) {
		AjaxJson j = new AjaxJson();
		
		//构造进度条信息对象200为操作总条数
		ProgressInfo progressInfo = new ProgressInfo(200);
		//构造进度条对象
		EispProgressListener progress = new EispProgressListener(request, progressInfo);
		
		for(int i = 0; i < 200; i++) {
			System.out.println("开始处理问题...");
			progress.next(); //更新进度条，处理下一条
			try {
				Thread.sleep(100);
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
			System.out.println("处理问题结束...");
		}
		
		j.setSuccess(true);
		j.setMsg("测试成功");
		return j;
	}
}
