package com.biz.eisp.base.utils;

import lombok.Data;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;

@Configuration
@PropertySource("classpath:dbconfigs.properties")
@Data
public class DBConfigUtil {

    @Value("${hibernate.dialect}")
    private String hibernateDialect;

    @Value("${validationQuery.sqlserver}")
    private String validationQuery;

    @Value("${hibernate.hbm2ddl.auto}")
    private String hibernateHbm2ddlAuto;

    @Value("${jdbc.url}")
    private String jdbcUrl;

    @Value("${jdbc.username}")
    private String jdbcUserName;

    @Value("${jdbc.password}")
    private String jdbcPassword;

    @Value("${redis.pool.maxActive}")
    private String redisMaxActive;

    @Value("${redis.pool.maxIdle}")
    private String redisMaxIdle;

    @Value("${redis.pool.maxWait}")
    private String redisMaxwait;

    @Value("${redis.pool.testOnBorrow}")
    private String redisTestInBorrow;

    @Value("${task.core_pool_size}")
    private String taskCorePoolSize;

    @Value("${task.queue_capacity}")
    private String taskQueueCapacity;

    @Value("${task.keep_alive_seconds}")
    private String taskKeepAliveSeconds;

    @Value("${task.max_pool_size}")
    private String taskMaxPoolSize;

    @Value("${redis.hostName}")
    private String redisHostName;

    @Value("${redis.port}")
    private String redisPort;

    @Value("${redis.password}")
    private String redisPassword;
}
