package com.biz.eisp.base.utils;

import com.biz.eisp.base.common.util.ResourceUtil;
import com.biz.eisp.base.core.service.JwtExtendService;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Date;

/**
 * 类JwtUtils的功能描述:
 * jwt工具类
 * @auther dyl
 * @date 2017-10-16 14:19:54
 */
@Component
public class JwtUtils {
    private Logger logger = LoggerFactory.getLogger(getClass());

    private String secret="";//ResourceUtil.getDbConfigProperty("jwt.secret");
    private long expire=3600L;//Long.valueOf(ResourceUtil.getDbConfigProperty("jwt.expire"));
    private String header= "";//ResourceUtil.getDbConfigProperty("jwt.header");

    @Autowired(required = false)
    private JwtExtendService jwtExtendService;

    /**
     * 生成jwt token
     */
    public String generateToken(String userId) {
        if (null != jwtExtendService){
            return jwtExtendService.generateToken(userId);
        }
        Date nowDate = new Date();
        //过期时间
        Date expireDate = new Date(nowDate.getTime() + expire * 1000);

        return Jwts.builder()
                .setHeaderParam("typ", "JWT")
                .setSubject(userId)//主题，也差不多是个人的一些信息
                .setIssuedAt(nowDate) //创建时间
                .setExpiration(expireDate)//添加Token过期时间
                //.setAudience(audience) //个人签名
                //.setIssuer(issuer) //发送谁
                .signWith(SignatureAlgorithm.HS256, secret)
                .compact();
    }

    public Claims getClaimByToken(String token) {
        if (null != jwtExtendService){
            return jwtExtendService.getClaimByToken(token);
        }
        try {
            return Jwts.parser()
                    .setSigningKey(secret)
                    .parseClaimsJws(token)
                    .getBody();
        }catch (Exception e){
            logger.debug("token验证错误,请重新登陆 ", e);
            return null;
        }
    }

    /**
     * token是否过期
     * @return  true：过期
     */
    public boolean isTokenExpired(Date expiration) {
        return expiration.before(new Date());
    }

    public String getSecret() {
        return secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public long getExpire() {
        return expire;
    }

    public void setExpire(long expire) {
        this.expire = expire;
    }

    public String getHeader() {
        return header;
    }

    public void setHeader(String header) {
        this.header = header;
    }
}
