package com.biz.eisp.base.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.commons.lang.StringUtils;

import com.biz.eisp.base.common.util.ReflectHelper;

/**
 * 切换${}中的值.
 * <p>
 * 
 * @author liukai
 * @version v1.0
 */
public class PatternUtils {

	public static final Pattern PATTERN = Pattern.compile("(?<=\\$\\{)[\\w|\\.]*(?=\\})");

	/**
	 * 使用Obj来其他exp中${}的值.
	 * <p>
	 * 
	 * @param exp
	 * @param obj
	 * @return
	 */
	public static String getPatternValue(String exp, Object obj) {
		Matcher matcher = PATTERN.matcher(exp);
		ReflectHelper r = null;
		if(obj != null) {
			r = new ReflectHelper(obj);
		}
		while (matcher.find()) {
			String name = matcher.group();
			Object result = r == null ? null : r.getMethodValue(name);
			exp = StringUtils.replace(exp, new StringBuilder().append("${").append(name).append("}").toString(),
					result == null ? "" : result.toString());
		}
		return exp == null ? "" : exp;
	}
}
