package com.biz.eisp.base.utils;

import freemarker.cache.TemplateLoader;

import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
/**
 * @Description: 模板加载器重写
 * @Author: xuduan
 * @Date: 2018/4/4 下午12:46
 */
public class StringTemplateLoader implements TemplateLoader {

	private static final String DEFAULT_TEMPLATE_KEY = "_default_template_key";
	private Map templates = new ConcurrentHashMap();

	public StringTemplateLoader(String defaultTemplate) {
		if (defaultTemplate != null && !defaultTemplate.equals("")) {
			templates.put(DEFAULT_TEMPLATE_KEY, defaultTemplate);
		}
	}

	public void AddTemplate(String name, String template) {
		if (name == null || template == null || name.equals("")
				|| template.equals("")) {
			return;
		}
		if (!templates.containsKey(name)) {
			templates.put(name, template);
		}
	}

	public StringTemplateLoader() {
	}

	public void putTemplate(String name, String templateSource) {
		this.putTemplate(name, templateSource, System.currentTimeMillis());
	}

	public void putTemplate(String name, String templateSource, long lastModified) {
		this.templates.put(name, new StringTemplateLoader.StringTemplateSource(name, templateSource, lastModified));
	}

	public void closeTemplateSource(Object templateSource) {
	}

	public Object findTemplateSource(String name) {
		return this.templates.get(name);
	}

	public long getLastModified(Object templateSource) {
		return ((StringTemplateLoader.StringTemplateSource)templateSource).lastModified;
	}

	public Reader getReader(Object templateSource, String encoding) {
		return new StringReader(((StringTemplateLoader.StringTemplateSource)templateSource).source);
	}
	private static class StringTemplateSource {
		private final String name;
		private final String source;
		private final long lastModified;

		StringTemplateSource(String name, String source, long lastModified) {
			if (name == null) {
				throw new IllegalArgumentException("name == null");
			} else if (source == null) {
				throw new IllegalArgumentException("source == null");
			} else if (lastModified < -1L) {
				throw new IllegalArgumentException("lastModified < -1L");
			} else {
				this.name = name;
				this.source = source;
				this.lastModified = lastModified;
			}
		}

		public boolean equals(Object obj) {
			return obj instanceof StringTemplateLoader.StringTemplateSource ? this.name.equals(((StringTemplateLoader.StringTemplateSource)obj).name) : false;
		}

		public int hashCode() {
			return this.name.hashCode();
		}
	}

}

