package com.biz.eisp.generatednum.commonds.impl;

import org.springframework.stereotype.Component;

import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.generatednum.commonds.GenerateCommond;

/**
 * 长度命令.
 * @author grover
 * @version v1.0
 */
@Component("lengthCommond")
public class LengthCommond extends BaseServiceImpl implements GenerateCommond {

	@Override
	public String processingRule(Object obj, String value) {
		String val = "";
		if(StringUtil.isNotEmpty(obj) && StringUtil.isNotEmpty(value)){
			Integer valueLength = obj.toString().length();
			try {
				Integer commandLength = Integer.parseInt(value);
				if(valueLength < commandLength){
					String appendZero = "";
					for (int i = 0; i < (commandLength-valueLength); i++) {
						appendZero+="0";
					}
					val = appendZero + obj;
				}else{
					val = obj.toString();
				}
			} catch (Exception e) {
				throw new BusinessException("LengthCommond命令处理长度,列格式length=3");
			}
		}
		return val;
	}
	
	@Override
	public String getKeyName() {
		return "length";
	}
}
