package com.biz.eisp.generatednum.factory;

import java.util.HashMap;
import java.util.Map;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;

import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.generatednum.commonds.GenerateCommond;

/**
 * 生成编码工厂实现.
 * @author liukai
 * @version v1.0
 */
@Service("generateNumFactory")
public class GenerateNumFactory implements GenerateNumFactoryInter,InitializingBean,ApplicationContextAware {
	/**
	 * 全局上下文.
	 */
	private ApplicationContext context;
	
	/**
	 * 命令集合.
	 */
	private Map<String, GenerateCommond> map = new HashMap<String, GenerateCommond>();

	public Map<String, GenerateCommond> getMap() {
		return map;
	}

	public void setMap(Map<String, GenerateCommond> map) {
		this.map = map;
	}
	/**
	 * 添加命令集合.
	 * @author grover
	 * @param key 命令key
	 * @param commond 命令处理实现
	 */
	public void addCommond(String key, GenerateCommond commond) {
		map.put(key, commond);
	}
	
	@Override
	public String generateNum(Object obj, String rule) {
		String[] ruleArr = rule.split(";");
		String num = "";
		for (String r : ruleArr) {
			String[] ruleObj = r.split("=");
			GenerateCommond commond = map.get(ruleObj[0]);
			if(StringUtil.isNotEmpty(commond)){
				num += commond.processingRule(obj, ruleObj[1]);
			}else{
				throw new BusinessException("编码处理,未找到key:"+ruleObj[0]+"的命令处理实现");
			}
		}
		return num;
	}

	@Override
	public void afterPropertiesSet() throws Exception {
		String[] GenerateCommondImpl = context.getBeanNamesForType(GenerateCommond.class);
		if(GenerateCommondImpl.length > 0){
			for (String beanName : GenerateCommondImpl) {
				GenerateCommond commond =context.getBean(beanName,GenerateCommond.class);
				map.put(commond.getKeyName(), commond);
			}
		}
	}

	@Override
	public void setApplicationContext(ApplicationContext applicationContext)
			throws BeansException {
		this.context = applicationContext;
	}
}
