package com.biz.eisp.generatednum.num.controller;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.EuPage;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.web.BaseController;
import com.biz.eisp.generatednum.num.service.TbNumRuleConfigService;
import com.biz.eisp.generatednum.num.util.TbNumRuleProvider;
import com.biz.eisp.generatednum.num.vo.TbNumRuleConfigVo;
/** 编号控制层.
 * @author grover
 * @version v1.0
 */
@Controller
@RequestMapping("/tbNumRuleConfigController")
public class TbNumRuleConfigController extends BaseController{
	/**
	 * 注入service
	 */
	@Autowired
	private TbNumRuleProvider tbNumRuleProvider;
	/**
	 * 注入service
	 */
	@Autowired
	private TbNumRuleConfigService tbNumRuleConfigService;
	
	/**
	 * 跳转编码规则主页.
	 * @author grover
	 * @param request 请求对象
	 * @return 编码规则主页
	 */
	@RequestMapping(value="goTbNumRuleMain", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goTbNumRuleMain(HttpServletRequest request) {
		return new ModelAndView("com/biz/eisp/numrule/tbNumRuleMain");
	}
	/**
	 * 跳转编码规则新增或者编辑主页.
	 * @author grover
	 * @param request 请求对象
	 * @param configVo  编码规则vo
	 * @return 编码规则新增或者编辑主页
	 */
	@RequestMapping(value="goForm", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goForm(HttpServletRequest request,TbNumRuleConfigVo configVo) {
		if(StringUtil.isNotEmpty(configVo.getId())){
			List<TbNumRuleConfigVo> list = tbNumRuleConfigService.findNumRule(configVo, new EuPage());
			if(!CollectionUtils.isEmpty(list)){
				TbNumRuleConfigVo numRuleConfigVo = list.get(0);
				request.setAttribute("vo", numRuleConfigVo);
			}
		}
		return new ModelAndView("com/biz/eisp/numrule/tbNumRuleForm");
	}
	/**
	 * 查询规则列表.
	 * @author grover
	 * @param tbNumRuleConfigVo 编号规则对象
	 */
	@RequestMapping(value="findTbNumRuleMain", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public DataGrid findTbNumRuleMain(HttpServletRequest request,
			TbNumRuleConfigVo tbNumRuleConfigVo, HttpServletResponse response) {
		Page page = new EuPage(request);
		List<TbNumRuleConfigVo> configVos = new ArrayList<TbNumRuleConfigVo>();
		try {
			configVos.addAll(tbNumRuleConfigService.findNumRule(tbNumRuleConfigVo, page));
		} catch (Exception e) {
			e.printStackTrace();
			throw new BusinessException("获取编码规则失败");
		}
		return new DataGrid(configVos, page);
	}
	/**
	 * 保存规则.
	 * @author grover
	 * @param tbNumRuleConfigVo 编号规则对象
	 * @return 成功或者失败
	 */
	@RequestMapping(value="saveTbNumRule", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson saveTbNumRule(TbNumRuleConfigVo tbNumRuleConfigVo) {
		AjaxJson j = new AjaxJson();
		try {
			j = tbNumRuleConfigService.saveTbNumRule(tbNumRuleConfigVo);
		} catch (Exception e) {
			j.setSuccess(false);
			j.setMsg("操作失败");
			e.printStackTrace();
		}
		return j;
	}
	/**
	 * 导出编码规则.
	 * @author grover
	 * @param tbNumRuleConfigVo 编码规则vo
	 * @param request 请求对象
	 * @param response 响应对象
	 */
	@RequestMapping(value = "exportXls", method = {RequestMethod.GET, RequestMethod.POST})
	public void exportXls(TbNumRuleConfigVo tbNumRuleConfigVo, HttpServletRequest request, HttpServletResponse response) {
		List<TbNumRuleConfigVo> configVos = new ArrayList<TbNumRuleConfigVo>();
		configVos.addAll(tbNumRuleConfigService.findNumRule(tbNumRuleConfigVo, null));
		doExportXls(response, request, configVos, TbNumRuleConfigVo.class, "编码规则列表");
	}
	
}
