package com.biz.eisp.generatednum.num.service;

import java.util.List;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.BaseService;
import com.biz.eisp.generatednum.num.vo.TbNumRuleConfigVo;

/** 
 * 编码规则接口类.
 * <p>编码规则的增删查改相关接口的定义.
 * @author grover
 * @version v1.0
 */
public interface TbNumRuleConfigService extends BaseService {
	/**
	 * 获取最大的值.
	 * <p>根据业务key获取最大计数值.
	 * @author grover
	 * @param naturalKey 业务key
	 * @return 值对象
	 */
	TbNumRuleConfigVo findMaxDataByKey(TbNumRuleConfigVo configVo);
	/**
	 * 获取编码规则列表.
	 * @author grover
	 * @param configVo 编号规则对象
	 * @param page 分页对象
	 * @return 对象集合
	 */
	List<TbNumRuleConfigVo> findNumRule(TbNumRuleConfigVo configVo, Page page);
	/**
	 * 验证重复.
	 * @author grover
	 * @param configVo 编号规则对象
	 * @return 验证信息
	 */
	AjaxJson validateKey(TbNumRuleConfigVo configVo);
	/**
	 * 保存编码规则.
	 * @author grover
	 * @param configVo 编号规则对象
	 * @return 成功或者失败
	 */
	AjaxJson saveTbNumRule(TbNumRuleConfigVo configVo);
	
}
