package com.biz.eisp.generatednum.num.service.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.List;

import org.apache.commons.beanutils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.generatednum.num.dao.TbNumRuleConfigDao;
import com.biz.eisp.generatednum.num.entity.TbNumRuleConfigEntity;
import com.biz.eisp.generatednum.num.service.TbNumRuleConfigService;
import com.biz.eisp.generatednum.num.transform.TbNumRuleEntityToVo;
import com.biz.eisp.generatednum.num.transform.TbNumRuleVoToEntity;
import com.biz.eisp.generatednum.num.vo.TbNumRuleConfigVo;

/** 
 *  编码规则接口实现类.
 * <p>编码规则的增删查改相关接口的实现<br>
 * @author grover
 * @version v1.0
 */
@Service("tbNumRuleConfigService")
@Transactional(propagation=Propagation.NOT_SUPPORTED)
public class TbNumRuleConfigServiceImpl extends BaseServiceImpl implements TbNumRuleConfigService {
	
	/**
	 * dao注入.
	 */
	@Autowired
	private TbNumRuleConfigDao tbNumRuleConfigDao;
	
	@Override
	public TbNumRuleConfigVo findMaxDataByKey(TbNumRuleConfigVo configVo) {
		//初始化计数数据
		TbNumRuleConfigVo tcv = null;
		//1.获取当前值
		TbNumRuleConfigEntity configEntity = findUniqueByProperty(TbNumRuleConfigEntity.class, "naturalKey", configVo.getNaturalKey());
		if(StringUtil.isNotEmpty(configEntity)){
			//转vo
			tcv = new TbNumRuleEntityToVo().apply(configEntity);
			//2.新值返入数据库
			backMaxCode(tcv);
		}else{
			//3.如果没有该key的计数值则新增一条纪录值
			configVo.setNumValue(Globals.INITNUM);
			backMaxCode(configVo);
			//返回
			tcv = new TbNumRuleConfigVo();
			try {
				BeanUtils.copyProperties(tcv, configVo);
			} catch (IllegalAccessException e) {
				e.printStackTrace();
			} catch (InvocationTargetException e) {
				e.printStackTrace();
			}
		}
		return tcv;
	}
	/**
	 * 新值返入数据库.
	 * @author grover
	 * @param maxNumber 当前最大值
	 * @param numRuleConfigVo 编码对象
	 * @return 编码纪录
	 */
	private TbNumRuleConfigEntity backMaxCode(TbNumRuleConfigVo numRuleConfigVo) {
		//vo转entity
		TbNumRuleConfigEntity configEntity = new TbNumRuleVoToEntity(this).apply(numRuleConfigVo);
		//反入数据库
		this.saveOrUpdate(configEntity);
		//主动flush操作，确保先执行更新序号操作
		this.getSession().flush();
		return configEntity;
	}
	@Override
	public List<TbNumRuleConfigVo> findNumRule(TbNumRuleConfigVo configVo, Page page) {
		List<TbNumRuleConfigVo> list = tbNumRuleConfigDao.findMaxNumByKey(configVo, page);
		return list;
	}
	@Override
	public AjaxJson validateKey(TbNumRuleConfigVo configVo) {
		AjaxJson j = new AjaxJson();
		if(StringUtil.isEmpty(configVo.getId())){
			String sql = "select count(1) from tb_numrule_config where natural_key=?";
			Long count = getCountForJdbcParam(sql, configVo.getNaturalKey());
			if(count > 1){
				j.setSuccess(false);
				j.setMsg("该业务组件已有规则纪录");
			}
		}else{
			String sql = "select count(1) from tb_numrule_config where natural_key=? and id <> ?";
			Long count = getCountForJdbcParam(sql, configVo.getNaturalKey(), configVo.getId());
			if(count > 1){
				j.setSuccess(false);
				j.setMsg("该业务组件已有规则纪录");
			}
		}
		return j;
	}
	@Override
	public AjaxJson saveTbNumRule(TbNumRuleConfigVo configVo) {
		AjaxJson j = new AjaxJson();
		j = validateKey(configVo);
		if(j.isSuccess()){
			TbNumRuleConfigEntity configEntity = new TbNumRuleVoToEntity(this).apply(configVo);
			saveOrUpdate(configEntity);
		}
		return j;
	}
}
