package com.biz.eisp.generatednum.num.transform;

import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.MyBeanUtils;
import com.biz.eisp.generatednum.num.entity.TbNumRuleConfigEntity;
import com.biz.eisp.generatednum.num.vo.TbNumRuleConfigVo;
import com.google.common.base.Function;

/** 
 * 编码规则entity转vo.
 * @author grover
 * @version v1.0
 */
public class TbNumRuleEntityToVo implements Function<TbNumRuleConfigEntity,TbNumRuleConfigVo> {
	
	@Override
	public TbNumRuleConfigVo apply(TbNumRuleConfigEntity entity) {
		TbNumRuleConfigVo vo = new TbNumRuleConfigVo();
		try {
			MyBeanUtils.copyBeanNotNull2Bean(entity, vo);
		} catch (Exception e) {
			e.printStackTrace();
			throw new BusinessException("编码规则entity转vo错误");
		}
		return vo;
	}

}
