package com.biz.eisp.generatednum.num.transform;

import java.util.Date;

import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.generatednum.num.entity.TbNumRuleConfigEntity;
import com.biz.eisp.generatednum.num.service.TbNumRuleConfigService;
import com.biz.eisp.generatednum.num.vo.TbNumRuleConfigVo;
import com.google.common.base.Function;

/** 
 * 编码规则vo转entity.
 * @author grover
 * @version v1.0
 */
public class TbNumRuleVoToEntity implements Function<TbNumRuleConfigVo, TbNumRuleConfigEntity> {
	/**
	 * 编码service.
	 */
	private TbNumRuleConfigService tbNumRuleConfigService;
	/**
	 * 带参构造方法.
	 * @param numRuleConfigService 编码service
	 */
	public TbNumRuleVoToEntity(TbNumRuleConfigService numRuleConfigService){
		if(tbNumRuleConfigService == null){
			this.tbNumRuleConfigService = numRuleConfigService;
		}
	}
	
	@Override
	public TbNumRuleConfigEntity apply(TbNumRuleConfigVo arg0) {
		TbNumRuleConfigEntity tbNumRuleConfigEntity = null;
		if(StringUtil.isNotEmpty(arg0.getId())){
			tbNumRuleConfigEntity = tbNumRuleConfigService.get(TbNumRuleConfigEntity.class, arg0.getId());
			if(StringUtil.isNotEmpty(tbNumRuleConfigEntity)){
				if(StringUtil.isEmpty(arg0.getFlag())){
					tbNumRuleConfigEntity.setNumValue(arg0.getNumValue()+1);
				}
				if(StringUtil.isNotEmpty(arg0.getNaturalKey())){
					tbNumRuleConfigEntity.setNaturalKey(arg0.getNaturalKey());
				}
				if(StringUtil.isNotEmpty(arg0.getRule())){
					tbNumRuleConfigEntity.setRule(arg0.getRule());
				}
				if(StringUtil.isNotEmpty(arg0.getRuleDesc())){
					tbNumRuleConfigEntity.setRuleDesc(arg0.getRuleDesc());
				}
			}else{
				tbNumRuleConfigEntity = new TbNumRuleConfigEntity();
				tbNumRuleConfigEntity.setNaturalKey(arg0.getNaturalKey());
				tbNumRuleConfigEntity.setNumValue(arg0.getNumValue());
				tbNumRuleConfigEntity.setRule(arg0.getRule());
				tbNumRuleConfigEntity.setRuleDesc(arg0.getRuleDesc());
			}
			tbNumRuleConfigEntity.setConfigDate(new Date());
		}else{
			tbNumRuleConfigEntity = new TbNumRuleConfigEntity();
			tbNumRuleConfigEntity.setNaturalKey(arg0.getNaturalKey());
			tbNumRuleConfigEntity.setNumValue(arg0.getNumValue());
			tbNumRuleConfigEntity.setRule(arg0.getRule());
			tbNumRuleConfigEntity.setRuleDesc(arg0.getRuleDesc());
			tbNumRuleConfigEntity.setConfigDate(new Date());
		}
		return tbNumRuleConfigEntity;
	}

}
