package com.biz.eisp.generatednum.num.util;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.generatednum.factory.GenerateNumFactoryInter;
import com.biz.eisp.generatednum.num.service.TbNumRuleConfigService;
import com.biz.eisp.generatednum.num.vo.TbNumRuleConfigVo;

/**
 * 获取编码规则数据.
 * @author grover
 * @version v1.0
 */
@Scope(value = "singleton")
@Component("tbNumRuleProvider")
public class TbNumRuleProvider {
	/**
	 * 注入编码生成service.
	 */
	@Autowired
	private TbNumRuleConfigService tbNumRuleConfigService;
	/**
	 * 注入生成最终编码工厂.
	 */
	@Autowired
	private GenerateNumFactoryInter generateNumFactory;

	/**
	 * 得到编码规则.
	 * @author grover
	 * @param configVo 规则vo
	 * @return 编码vo对象
	 */
	private synchronized TbNumRuleConfigVo getMaxData(TbNumRuleConfigVo configVo) {
		TbNumRuleConfigVo vo = tbNumRuleConfigService.findMaxDataByKey(configVo);
		return vo;
	}
	/**
	 * 替换规则并返回.
	 * @author grover
	 * @param key 业务组件对象
	 * @return 编号
	 */
	public String getMaxNum(String key){
		//返回字符串
		String numStr = "";
		//获取配置的编码规则
		TbNumRuleConfigVo configVo = new TbNumRuleConfigVo();
		configVo.setNaturalKey(key);
		//获取当前最大数据
		TbNumRuleConfigVo vo = getMaxData(configVo);
		//获取规则
		String rule = vo.getRule();
		if(StringUtil.isNotEmpty(rule)){
			//获取值
			numStr = generateNumFactory.generateNum(vo.getNumValue(), rule);
		}else{
			throw new BusinessException("未找到该业务key:"+key+"的规则");
		}
		return numStr;
	}
}
