package com.biz.eisp.log.controller;

import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jdk.nashorn.internal.ir.RuntimeNode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.core.page.EuPage;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.web.BaseController;
import com.biz.eisp.log.service.TmLogService;
import com.biz.eisp.log.vo.TmLogVo;

/** 
 * 日志管理控制器
 * @author wuzhujun
 * @version v1.0
 */
@Controller
@RequestMapping("/tmLogController")
public class TmLogController extends BaseController{

	@Autowired
	private TmLogService tmLogService; //注入日志Service
	
	/**
	 * <p>跳转到日志管理主页面<br>
	 * @author wuzhujun
	 * @return 日志管理主界面
	 */
	@RequestMapping(value = "goTmLogMain",method = {RequestMethod.GET,RequestMethod.POST})
	public ModelAndView goTmUserMain() {
		return new ModelAndView("com/biz/eisp/log/tmLogMain");
	}
	
	/**
	 * <p>跳转到日志管理主页面<br>
	 * @author wuzhujun
	 * @return 日志管理主界面
	 */
	@RequestMapping(value = "goTmLogDetailMain", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goTmLogDetailMain( HttpServletRequest request) {
		String businessId=request.getParameter("id");
		request.setAttribute("actionUrl", "tmLogController/findTmLogList?businessId="+businessId);
		return new ModelAndView("com/biz/eisp/log/tmLogDetailMain");
	}
	
	/**
	 * 分页获取日志列表信息
	 * @author wuzhujun
	 * @param tmLogEntity 日志实体模型
	 * @param request 请求对象
	 * @param response 响应对象
	 */
	@RequestMapping(value = "findTmLogList", method = {RequestMethod.GET, RequestMethod.POST})
	public void findTmLogList(TmLogVo tmLogVo, HttpServletRequest request, HttpServletResponse response) {
		Page page = new EuPage(request);
		List <TmLogVo> tmLogList;
		try {
			tmLogList = tmLogService.findTmLogList(tmLogVo, page);
		} catch (Exception e) {
			e.printStackTrace();
			throw new BusinessException("获取日志信息失败！"+e.getMessage());
		}
		this.datagridReturn(response, tmLogList, page);
	}
	
	/**
	 * 导出Excel
	 * @author wuzhujun
	 * @param tmLogVo 日志Vo
	 * @param request 请求对象
	 * @param response 响应对象
	 */
	@RequestMapping(value = "exportXls", method = {RequestMethod.GET, RequestMethod.POST})
	public void exportXls(TmLogVo tmLogVo, HttpServletRequest request, HttpServletResponse response) {
		List<TmLogVo> tmLogVoList=
				tmLogService.findTmLogList(tmLogVo, null);
		doExportXls(response, request, tmLogVoList, TmLogVo.class, "日志列表");
	}
}
