package com.biz.eisp.log.curd;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.constant.HibernateConstant;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.ResourceConfigUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.utils.DateUtils;
import com.biz.eisp.base.utils.SysConfigUtils;
import com.biz.eisp.log.entity.TmExecuteMethodEntity;
import com.biz.eisp.log.entity.TmLogEntity;
import com.biz.eisp.mdm.config.util.DynamicConfigUtil;
import com.biz.eisp.mdm.dict.util.DictUtil;
import com.biz.eisp.mdm.dict.vo.TmDictDataVo;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.event.spi.*;
import org.hibernate.persister.entity.EntityPersister;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.persistence.JoinColumn;
import javax.persistence.Table;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 日志监听器，监听CURD操作
 * <p>
 * 监听Hibernate的Insert，Update，Delete操作。<br>
 * 
 * @author liukai
 * @version v1.0
 */
@Component
public class LoggerListener implements PostInsertEventListener, PostUpdateEventListener, PostDeleteEventListener {

	@Autowired
	private SysConfigUtils sysConfigUtils;

	private static final long serialVersionUID = 1L;
	 String nameProperty="";
	/**
	 * 新增日志记录
	 */
	@SuppressWarnings("deprecation")
	@Override
	public void onPostInsert(PostInsertEvent event) {
		Object object = event.getEntity();
		// 判断是否继承Loggerable接口
		if (object instanceof Loggerable) {
			String businessDesc = ((Loggerable) object).businessDesc();
			String content = ((Loggerable) object).addLogContent();
			
			if(StringUtil.isEmpty(content)){
				// 获取实体的表名
				String tableName = getTableNameByEntity(object,null,null);
				content=getAddLogContent(tableName, object);
			}

			TmLogEntity tmLogEntity = new TmLogEntity();
			tmLogEntity.setContent(content);
			tmLogEntity.setOperationType("INSERT");
			tmLogEntity.setBusinessId(getPropertyValue(object, "id"));
			tmLogEntity.setBusinessDesc(businessDesc);
			tmLogEntity.setPositionName(StringUtil.isNotEmpty(ResourceConfigUtils
					.getCurrPosition()) ? ResourceConfigUtils.getCurrPosition()
					.getPositionName() : "手机新增");
			if(StringUtil.isNotEmpty(content)){
				this.saveEntity(event, tmLogEntity);
			}
		}
	}

	@Override
	public boolean requiresPostCommitHanding(EntityPersister persister) {
		return false;
	}

	/**
	 * 修改日志记录
	 */
	@Override
	public void onPostUpdate(PostUpdateEvent event) {
		Object object = event.getEntity();

		// 判断是否继承Loggerable接口
		if (object instanceof Loggerable) {
			String businessDesc = ((Loggerable) object).businessDesc();
			// 已修改了的字段
			int[] dirtyProperties = event.getDirtyProperties();
			// 历史数据
			Object[] old = event.getOldState();
			// 新数据
			Object[] now = event.getState();
			// 属性列表
			String[] propertys = event.getPersister().getPropertyNames();
			// 日志记录内容
			String content =  ((Loggerable) object).
					updateLogContent(getModifyObjectList(object,dirtyProperties, propertys,old, now));
			if (content==null&&dirtyProperties != null && dirtyProperties.length > 0) {
				content="";
				// 获取实体的表名
				String tableName = getTableNameByEntity(object,null,null);

				for (int i = 0; i < dirtyProperties.length; i++) {
					// 修改属性的索引
					int index = dirtyProperties[i];
					
					// 拦截器拦截每次修改后修改 修改人和修改时间 所以无需追加日志
					if (HibernateConstant.UPDATE_NAME.equals(propertys[index])
							||HibernateConstant.CREATE_DATE.equals(propertys[index])
							||HibernateConstant.CREATE_NAME.equals(propertys[index])
							||HibernateConstant.UPDATE_DATE.equals(propertys[index])
							||HibernateConstant.CREATE_POS_ID.equals(propertys[index])
							||HibernateConstant.UPDATE_POS_ID.equals(propertys[index])
							||Globals.LOGIN_ERROR.equals(propertys[index])) {
						continue;
					}
					// 获取被修改属性的描述
					String propertyDesc = "";
					String field = propertys[index];
					Map<String, String> descMap=DynamicConfigUtil.allTableConfigColumn.get(tableName);
					if(descMap!=null){
						propertyDesc = descMap.get(field);
					}
					if(StringUtil.isEmpty(propertyDesc)){
						//属于引用实体字段
						Map<String, String> columnMap = DynamicConfigUtil.allTableConfigField.get(tableName);
						if(columnMap!=null){
							String fieldName=getColumnNameByPropertyField(object, field);
							//获取字段描述
							propertyDesc = columnMap.get(fieldName);
						}
					}
					
					if(StringUtil.isEmpty(propertyDesc)){
						propertyDesc = field;
					}
					// 修改前数据值
					Object oldVal = old[index];
					// 修改后数据值
					Object nowVal = now[index];
					if(StringUtil.isEmpty(oldVal)&&StringUtil.isEmpty(nowVal)){
						continue;
					}
					
					if (oldVal != null) {
						if (!isBaseDataType(oldVal)) {
							String propertyField = getColumnNameByPropertyField(object, field);
							Map<String, String> fieldMap = DynamicConfigUtil.allTableConfigField.get(tableName);
							
							if (fieldMap!=null&&!fieldMap.isEmpty()) {
								//获取字段描述
								propertyDesc = fieldMap.get(propertyField);
							}
							// 获取实体的表名
							String propertyTableName = getTableNameByEntity(oldVal,object,field);
							//通过表名获取名称字段
							if(StringUtil.isNotEmpty(propertyTableName)){
								String nameProperty=getSearchColumnName(propertyTableName);
								oldVal = getPropertyValue(oldVal, nameProperty);
							}else{
								oldVal= getPropertyValue(oldVal, "id");
							}
							
						}
						//日期类型日志记录
						if (oldVal instanceof Date) {
							Date newDate = (Date) oldVal;
							oldVal = DateUtils.date2Str(newDate, DateUtils.datetimeFormat);
						}
					}

					if (nowVal != null) {
						if (!isBaseDataType(nowVal)) {
							// 获取实体的表名
							String propertyTableName = getTableNameByEntity(nowVal,object,field);
							//通过表名获取名称字段
							if(StringUtil.isNotEmpty(propertyTableName)){
								String nameProperty=getSearchColumnName(propertyTableName);
								nowVal = getPropertyValue(nowVal, nameProperty);
							}else{
								nowVal= getPropertyValue(nowVal, "id");
							}
						}
						//日期类型日志记录
						if (nowVal instanceof Date) {
							Date newDate = (Date) nowVal;
							nowVal = DateUtils.date2Str(newDate, DateUtils.datetimeFormat);
						}
					}

					//读取当前表的数据字典值
					Map<String, String> dictMap = DynamicConfigUtil.allTableConfigDictColumn.get(tableName);
					String propertyDictType =null;
					if(dictMap!=null){
						propertyDictType=dictMap.get(field);
					}
					if (StringUtil.isNotEmpty(propertyDictType)) {
						
						//获取数据字典值 
						List<TmDictDataVo> dictDatas = 
								DictUtil.getDictList(propertyDictType);
						
						//历史数据数据字典值
						String oldV="";
						for (TmDictDataVo tt : dictDatas) {
							String v=String.valueOf(oldVal);
							if(v.indexOf(",")!=-1){
								for(String str:v.split(",")){
									if (str.equals(tt.getDictCode())) {
										oldV+=tt.getDictValue()+" ";
									}
								}
							}else if (v.equals(tt.getDictCode())) {
								oldV=tt.getDictValue();
								break;
							}
						}
					
						if(StringUtil.isEmpty(oldV)){
							content += "字段[<b>" + propertyDesc + "</b>],原:<b>为空</b>";
						}else{
							content += "字段[<b>" + propertyDesc + "</b>],原:<b>" +oldV+"</b>";
						}
						
						//修改后数据数据字典值 
						String newV="";
						for (TmDictDataVo tt : dictDatas) {
							String v=String.valueOf(nowVal);
							if(v.indexOf(",")!=-1){
								for(String str:v.split(",")){
									if (str.equals(tt.getDictCode())) {
										newV+=tt.getDictValue()+" ";
									}
								}
							}else if (v.equals(tt.getDictCode())) {
								newV= tt.getDictValue() ;
								break;
							}
						}
						if(StringUtil.isEmpty(nowVal)){
							content +=",修改为:<b>空</b></br>";
						}else{
							content +=",修改为:<b>" + newV + "</b></br>";
						}
						
					} else {
						
						if((oldVal!=null&&oldVal.toString().length()>0)
								||(nowVal!=null&&nowVal.toString().length()>0)){
							if(oldVal==null){
								oldVal="为空";
							}
							if(nowVal==null){
								nowVal="空";
							}
							content += "字段[<b>" + propertyDesc + "</b>],原:<b>" + oldVal + ",修改为:<b>" + nowVal
									+ "</b></br>";
						}
				
					}
				}
			}
			// 创建日志实体
			TmLogEntity tmLogEntity = new TmLogEntity();
			tmLogEntity.setContent(content);
			tmLogEntity.setOperationType("UPDATE");
			tmLogEntity.setBusinessId(getPropertyValue(object, "id"));
			tmLogEntity.setBusinessDesc(businessDesc);
			tmLogEntity.setPositionName(StringUtil.isNotEmpty(ResourceConfigUtils
					.getCurrPosition()) ? ResourceConfigUtils.getCurrPosition()
					.getPositionName() : "手机新增");
			if(StringUtil.isNotEmpty(content)){
				this.saveEntity(event, tmLogEntity);

				//String saveExecuteMethod = ResourceUtil.getSysConfigProperty("saveExecuteMethod");
				String saveExecuteMethod = sysConfigUtils.getSaveExecuteMethod();
				if(StringUtil.isNotBlank(saveExecuteMethod) && saveExecuteMethod.equals("Y")) {
					saveExecuteMethodName(event, tmLogEntity.getId());
				}
			}
		}
	}

	/**
	 * 获取调用方法入口
	 * @return
	 */
	private void saveExecuteMethodName(PostUpdateEvent event, String id) {
		Throwable ex = new Throwable();
		StackTraceElement[] stackElements = ex.getStackTrace();
		String msg = "调用方法：";
		if(stackElements != null) {
			for(StackTraceElement element : stackElements) {
				msg += element.getFileName() + ";" +  element.getMethodName() + "<br>";
			}
		}

		TmExecuteMethodEntity entity = new TmExecuteMethodEntity();
		entity.setBusinessId(id);
		entity.setContent(msg);
		this.saveEntity(event, entity);
	}

	/**
	 * 删除日志记录
	 */
	@Override
	public void onPostDelete(PostDeleteEvent event) {
		Object object = event.getEntity();
		if (object instanceof Loggerable) {
			String content = ((Loggerable) object).addLogContent();
			String businessDesc = ((Loggerable) object).businessDesc();
			if(StringUtil.isEmpty(content)){
				// 获取实体的表名
				String tableName = getTableNameByEntity(object,null,null);
				content=getAddLogContent(tableName, object);
			}
			// 创建日志实体
			TmLogEntity tmLogEntity = new TmLogEntity();
			tmLogEntity.setContent(content);
			tmLogEntity.setOperationType("DELETE");
			tmLogEntity.setBusinessId(getPropertyValue(object, "id"));
			tmLogEntity.setBusinessDesc(businessDesc);
			tmLogEntity.setPositionName(StringUtil.isNotEmpty(ResourceConfigUtils
					.getCurrPosition())? ResourceConfigUtils.getCurrPosition()
					.getPositionName() : "手机新增");
			this.saveEntity(event, tmLogEntity);
		}
	}
	
	/**
	 * 拼装已修改字段
	 * @param object
	 * @param dirtyProperties
	 * @param propertys
	 * @param oldVals
	 * @param newVals
	 * @return
	 */
	private List<ModifyObject> getModifyObjectList(Object object,int[] dirtyProperties,String[] propertys,Object[] oldVals,Object[] newVals){
		List<ModifyObject> modifyList=new ArrayList<ModifyObject>();
		if (StringUtil.isNotEmpty(dirtyProperties) && dirtyProperties.length > 0) {
			for (int i = 0; i < dirtyProperties.length; i++) {
				ModifyObject modifyObject=new ModifyObject();
				// 修改属性的索引
				int index = dirtyProperties[i];
				String field = propertys[index];
				// 拦截器拦截每次修改后修改 修改人和修改时间 所以无需追加日志
				if (HibernateConstant.UPDATE_NAME.equals(propertys[index])
						||HibernateConstant.CREATE_DATE.equals(propertys[index])
						||HibernateConstant.CREATE_NAME.equals(propertys[index])
						||HibernateConstant.UPDATE_DATE.equals(propertys[index])
						||HibernateConstant.CREATE_POS_ID.equals(propertys[index])
						||HibernateConstant.UPDATE_POS_ID.equals(propertys[index])
						||Globals.LOGIN_ERROR.equals(propertys[index])) {
					continue;
				}
				// 修改前数据值
				Object oldVal = oldVals[index];
				// 修改后数据值
				Object nowVal = newVals[index];
				modifyObject.setFieldName(field);
				modifyObject.setNowVal(nowVal);
				modifyObject.setOldVal(oldVal);
				modifyList.add(modifyObject);
			}
		}
		return modifyList;
	}
	
	// 另外启动一个session处理审核日志的保存
	private void saveEntity(AbstractEvent event, TmLogEntity tmLogEntity) {
		SessionFactory sessionFactory = event.getSession().getSessionFactory();
		Session session = sessionFactory.openSession();
		Transaction tx = session.beginTransaction();
		try {
			session.persist(tmLogEntity);
			tx.commit();
		} catch (Exception e) {
			e.printStackTrace();
			tx.rollback();
		}
		session.close();
	}

	// 另外启动一个session处理审核日志的保存
	private void saveEntity(AbstractEvent event, TmExecuteMethodEntity tmExecuteMethodEntity) {
		SessionFactory sessionFactory = event.getSession().getSessionFactory();
		Session session = sessionFactory.openSession();
		Transaction tx = session.beginTransaction();
		try {
			session.persist(tmExecuteMethodEntity);
			tx.commit();
		} catch (Exception e) {
			e.printStackTrace();
			tx.rollback();
		}
		session.close();
	}

	/**
	 * 获取实体id值
	 * 
	 * @param entity
	 * @return
	 */
	private String getPropertyValue(Object entity, String propertyName) {
		if (entity == null) {
			return null;
		}

		Class clazz = entity.getClass();
		Object value = null;
		boolean flag = Loggerable.class.isAssignableFrom(clazz);
		if(flag){
			try {
				PropertyDescriptor property =null;
				if(propertyName.equals("id")){
					Class c = clazz.getSuperclass();
					property = new PropertyDescriptor(propertyName, c);
				}else{
					property = new PropertyDescriptor(propertyName, clazz);
				}
				// 获得get方法
				Method getMethod = property.getReadMethod();
				// 执行get方法返回一个Object
				value = getMethod.invoke(entity);
			} catch (Exception e) {
				e.printStackTrace();
				throw new BusinessException(entity.getClass().getName() + "未找到"+propertyName+"属性字段");
			}
		}
		return (String) value;
	}

	/**
	 * 是否基本数据类型.
	 * 
	 * @author grover
	 * @param param
	 *            值
	 * @return true是 false否
	 */
	private boolean isBaseDataType(Object param) {
		// 默认不是基本数据类型
		boolean flag = false;
		if (!StringUtil.isNotEmpty(param)) {
			flag = true;
		}
		if (param instanceof Integer || param instanceof String || param instanceof Double || param instanceof Float
				|| param instanceof Long || param instanceof Boolean || param instanceof Date
				|| param instanceof Short||param instanceof BigDecimal) {
			flag = true;
		}
		return flag;
	}
	
	/**
	 * 新增默认日志（字段不为空自动添加）
	 */
	private String getAddLogContent(String tableName,Object entity){
		String logContent="";
		Field[]  fields=entity.getClass().getDeclaredFields();
		if(!CollectionUtil.mapNotEmpty( DynamicConfigUtil.allTableConfigColumn.get(tableName))){
			return "实体"+ entity.getClass().getSimpleName()+",新增日志logContent方法返回为空且不存在主数据动态配置表";
		}
	
		try {
			 for(Field field:fields){
				String name=field.getName();
				if (StringUtil.equals(name, "serialVersionUID")
						||HibernateConstant.UPDATE_NAME.equals(name)
						||HibernateConstant.UPDATE_DATE.equals(name)
						||HibernateConstant.CREATE_NAME.equals(name)
						||HibernateConstant.CREATE_POS_ID.equals(name)
						||HibernateConstant.UPDATE_POS_ID.equals(name)
						||HibernateConstant.CREATE_DATE.equals(name)) {
					continue;
				}
				PropertyDescriptor property = new PropertyDescriptor(name, entity.getClass());
				// 获得get方法
				Method getMethod = property.getReadMethod();
				// 执行get方法返回一个Object
				Object value = getMethod.invoke(entity);
				Object propertyValue=null;
				if(value!=null&&!(value instanceof List)){
					String propertyDesc="";
					if(isBaseDataType(value)){
						Map<String, String> fieldMap = DynamicConfigUtil.allTableConfigColumn.get(tableName);
						propertyDesc=fieldMap.get(name);
						propertyValue= value;
						
						//读取当前表的数据字典值
						Map<String, String> dictMap = DynamicConfigUtil.allTableConfigDictColumn.get(tableName);
						String propertyDictType =null;
						if(dictMap!=null){
							propertyDictType=dictMap.get(name);
						}
						if (StringUtil.isNotEmpty(propertyDictType)) {
							//获取数据字典值 
							List<TmDictDataVo> dictDatas = 
									DictUtil.getDictList(propertyDictType);
							
							//数据数据字典值
							String dictValue="";
							for (TmDictDataVo tt : dictDatas) {
								String v=String.valueOf(value);
								if(v.indexOf(",")!=-1){
									for(String str:v.split(",")){
										if (str.equals(tt.getDictCode())) {
											dictValue+=tt.getDictValue()+" ";
										}
									}
								}else if (v.equals(tt.getDictCode())) {
									dictValue=tt.getDictValue();
									break;
								}
							}
							propertyValue=StringUtil.isNotEmpty(dictValue)?dictValue:propertyValue;
						}
					}else{
						//属于引用实体字段
						Map<String, String> columnMap = DynamicConfigUtil.allTableConfigField.get(tableName);
						String fieldName=getColumnNameByPropertyField(entity, field.getName());//获取
						//获取字段描述
						propertyDesc = columnMap.get(fieldName);
						//获取表名
						Class clazz=property.getPropertyType();
						boolean hasTableName1 =clazz.isAnnotationPresent(Table.class);
						if (hasTableName1) {
							Table table =(Table) clazz.getAnnotation(Table.class);
							String tablename=table.name();
							String propertyName=getSearchColumnName(tablename);
							propertyValue=getPropertyValue(value, propertyName);
						}
					
					}
					if(StringUtil.isNotEmpty(propertyValue)&&StringUtil.isNotEmpty(propertyDesc)){
						logContent+="字段[<b>"+propertyDesc+"</b>]:"+propertyValue+"<br>";
					}
				}
			 }
		} catch (IntrospectionException e) {
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			e.printStackTrace();
		} catch (IllegalArgumentException e) {
			e.printStackTrace();
		} catch (InvocationTargetException e) {
			e.printStackTrace();
		}
		return logContent;
	}

	/**
	 * 获取实体表名tableName，根据entity的Table注解
	 * @param obj 属性实体对象
	 * @param pobj 修改实体对象
	 * @param pobj 当前修改字段名称
	 * @return
	 */
	private String getTableNameByEntity(Object obj,Object pobj,String field) {
		String tableName = null;
		boolean hasTableName = obj.getClass().isAnnotationPresent(Table.class);
		if (hasTableName) {
			Table table = obj.getClass().getAnnotation(Table.class);
			tableName = table.name().toUpperCase();
		}else{
			try {
				PropertyDescriptor property = new PropertyDescriptor(field, pobj.getClass());
				Class clazz=property.getPropertyType();
				boolean hasTableName1 =clazz.isAnnotationPresent(Table.class);
				if (hasTableName1) {
					Table table =(Table) clazz.getAnnotation(Table.class);
					tableName = table.name().toUpperCase();
				}
			} catch (IntrospectionException e) {
				e.printStackTrace();
			}
			
		}
		return tableName;
	}

	/**
	 * 获取字段，根据field的JoinColumn注解关联的列名
	 * 
	 * @param entity
	 *            实体对象
	 * @param field
	 *            字段
	 * @return
	 */
	private String getColumnNameByPropertyField(Object entity, String field) {
		if (entity == null) {
			return null;
		}

		String fieldName = null;
		try {
			Class clazz = entity.getClass();
			PropertyDescriptor property = new PropertyDescriptor(field, clazz);
			// 获得get方法
			Method getMethod = property.getReadMethod();
			// 判断是不是有JoinColumn注解
			boolean hasJoinColumn = getMethod.isAnnotationPresent(JoinColumn.class);
			if (hasJoinColumn) {
				JoinColumn table = getMethod.getAnnotation(JoinColumn.class);
				fieldName = table.name().toUpperCase();
			}
		} catch (IntrospectionException e) {
			e.printStackTrace();
		}
		return fieldName;
	}
	
	/**
	 * 获取实体name字段 
	 * @param tableName
	 * @return
	 */
	private String getSearchColumnName(String tableName){
		if(StringUtil.isNotEmpty(tableName)){
			tableName=tableName.toLowerCase();
		}
		tableName=tableName.substring(3, tableName.length());
		StringBuffer sb=new StringBuffer("Name");
		String  propertyName="";
		if(tableName.indexOf("_")==-1){
			propertyName=tableName;
		}else{
			  propertyName=StringUtil.underlineToCamel(tableName);
		}
		return sb.insert(0, propertyName).toString();
	}
	
}
