package com.biz.eisp.log.curd;

import java.util.List;

/**
 * 是否对PO（Entity）实体进行日志记录接口。
 * <p>
 * 使用方法：<br>
 * 1.Entity实现接口即可。注意必须是Hibernate的Entity实体
 * 2.实现logContent方法。
 * @author liukai
 * @version v1.0
 */
public interface Loggerable {

	/**
	 * 新增时保存到数据库中的日志内容.
	 * <p>请开发人员实现需要保存到数据库中的日志内容<br>
	 * 比如：学生实体StudentEntity 的内容：studentCode:'001',studentName:'张三'
	 * @return 日志内容
	 */
	public String addLogContent();
	
	/**
	 * 修改时保存到数据库中的日志内容.
	 * <p>请开发人员实现需要保存到数据库中的日志内容<br>
	 * @param modifyFieldList 修改的字段列表 
	 * @return 日志内容
	 */
	public String updateLogContent( List<ModifyObject> modifyFieldList);
	
	/**
	 * 保存日志的业务描述
	 *<p>请开发人员实现需要保存到数据库中的日志业务描述<br>
	 * 比如：客户TmCustonerEntity 的内容：客户基本信息
	 * @return
	 */
	public String businessDesc();
	
}
