package com.biz.eisp.log.entity;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

import com.biz.eisp.base.common.identity.IdEntity;

/**
 * 日志实体.
 * <p>关联数据库表tm_log
 * @author liukai
 * @version v1.0
 */
@Entity
@Table(name = "tm_log", schema = "")
public class TmLogEntity extends IdEntity implements java.io.Serializable{

	
	private static final long serialVersionUID = 1L;
	/**
	 * 操作类型 insert、update 、delete
	 */
	private String operationType;
	/**
	 * 日志内容
	 */
	private String content;
	/**
	 * 业务ID
	 */
	private String businessId;
	/**
	 * 业务描述
	 */
	private String businessDesc;
	/**
	 * 修改人职位信息
	 */
	private String positionName;
	/**
	 * 创建人
	 */
	private String createName;
	/**
	 * 创建时间
	 */
	private Date createDate;
	
	
	/**
	 *方法：取得java.lang.String
	 * @return java.lang.String  操作类型 insert、update 、delete
	 */
	@Column(name = "OPERATION_TYPE")
	public String getOperationType() {
		return operationType;
	}
	/**
	 * 方法：设置 java.lang.String 
	 * @param java.lang.String  操作类型 insert、update 、delete
	 */
	public void setOperationType(String operationType) {
		this.operationType = operationType;
	}
	/**
	 * 方法：取得java.lang.String
	 * @return java.lang.String 日志内容
	 */
	@Column(name = "content")
	public String getContent() {
		return content;
	}
	/**
	 * 方法：设置java.lang.String
	 * @param java.lang.String 日志内容
	 */
	public void setContent(String content) {
		this.content = content;
	}
	/**
	 * 方法：取得java.lang.String
	 * @return java.lang.String 业务ID
	 */
	@Column(name = "business_Id")
	public String getBusinessId() {
		return businessId;
	}
	/**
	 *方法：设置java.lang.String
	 * @param java.lang.String 业务ID
	 */
	public void setBusinessId(String businessId) {
		this.businessId = businessId;
	}
	/**
	 * 方法：取得java.lang.String
	 * @return java.lang.String 业务描述
	 */
	@Column(name = "business_Desc")
	public String getBusinessDesc() {
		return businessDesc;
	}
	/**
	 * 方法：设置java.lang.String 
	 * @param  java.lang.String 业务描述
	 */
	public void setBusinessDesc(String businessDesc) {
		this.businessDesc = businessDesc;
	}
	/**
	 *方法: 取得 java.lang.String
	 *@return: java.lang.String 修改人职位信息
	 */
	@Column(name = "POSITION_NAME")
	public String getPositionName() {
		return positionName;
	}
	/**
	 *方法: 设置 java.lang.String
	 *@param: java.lang.String 修改人职位信息
	 */
	public void setPositionName(String positionName) {
		this.positionName = positionName;
	}
	/**
	 *方法: 取得 java.lang.String
	 *@return: java.lang.String 创建人
	 */
	@Column(name = "create_name")
	public String getCreateName() {
		return createName;
	}
	
	/**
	 *方法：设置java.lang.String 
	 * @param java.lang.String 创建人
	 */
	public void setCreateName(String createName) {
		this.createName = createName;
	}
	/**
	 *方法：取得java.util.Date
	 * @return java.util.Date 创建时间
	 */
	@Column(name = "create_date")
	public Date getCreateDate() {
		return createDate;
	}
	/**
	 *方法：设置java.util.Date
	 * @param java.util.Date 创建时间
	 */
	public void setCreateDate(Date createDate) {
		this.createDate = createDate;
	}
	
	
	

}
