package com.biz.eisp.log.service.impl;

import java.util.ArrayList;
import java.util.List;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.log.entity.TmLogEntity;
import com.biz.eisp.log.service.TmLogService;
import com.biz.eisp.log.transformer.TmLogEntityToTmLogVo;
import com.biz.eisp.log.vo.TmLogVo;

/**
 * 日志管理服务层接口实现
 * @author wuzhujun
 * @version v1.0
 */
@Service("tmLogService")
@Transactional
public class TmLogServiceImpl extends BaseServiceImpl implements TmLogService {

	@Override
	public List<TmLogVo> findTmLogList(TmLogVo tmLogVo, Page page) {
		String hql = "from TmLogEntity t  where 1 = 1 ";
		String content = tmLogVo.getContent();
		String createName = tmLogVo.getCreateName();
		String opreateType = tmLogVo.getOperationType();
		String businessDesc=tmLogVo.getBusinessDesc();
		String businessId=tmLogVo.getBusinessId();
		
		if(content!=null&&!"".equals(content)){
			hql+=" and t.content like "+"'%"+content+"%'";
		}
		if(opreateType!=null&&!"".equals(opreateType)){
			hql+=" and t.operationType like "+"'%"+opreateType+"%'";
		}
		if(createName!=null&&!"".equals(createName)){
			hql+=" and t.createName like "+"'%"+createName+"%'";
		}
		if(businessDesc!=null&&!"".equals(businessDesc)){
			hql+=" and t.businessDesc like "+"'%"+businessDesc+"%'";
		}
		if(businessId!=null&&!"".equals(businessId)){
			if(businessId.indexOf(",") != -1){
				hql+=" and t.businessId in ("+businessId+")";
			}else{
				hql+=" and t.businessId = "+"'"+businessId+"'";
			}
		}
		
		hql+=" order by createDate desc";
		List<TmLogEntity> list   = new ArrayList<TmLogEntity>();
		if(page!=null){
			list = this.findByHql(hql, page);
		}else{
			list = this.findByHql(hql);
		}
		
		List<TmLogVo> TmLogVoList = new ArrayList<TmLogVo>();
		TmLogEntityToTmLogVo tranform = new TmLogEntityToTmLogVo(this);
		for(TmLogEntity te:list){
			TmLogVoList.add(tranform.apply(te));
		}
		return TmLogVoList;
	}

	@Override
	public TmLogEntity findTmLogById(String id) {
		TmLogEntity  tmLogEntity = super.get(TmLogEntity.class, id);
		if(StringUtil.isNotEmpty(tmLogEntity)){
			return tmLogEntity;
		}
		return null;
	}
	
}
