package com.biz.eisp.log.transformer;

import com.biz.eisp.base.common.util.MyBeanUtils;
import com.biz.eisp.log.entity.TmLogEntity;
import com.biz.eisp.log.service.TmLogService;
import com.biz.eisp.log.vo.TmLogVo;
import com.google.common.base.Function;

/** 
 * 日志管理po转vo
 * @author wuzhujun
 * @version v1.0
 */
public class TmLogEntityToTmLogVo  implements Function<TmLogEntity,TmLogVo>{
	private TmLogService tmLogService;
	
	public TmLogEntityToTmLogVo(TmLogService tmLogService){
		this.tmLogService = tmLogService;
	}
	@Override
	public TmLogVo apply(TmLogEntity entity) {
		TmLogVo tmLogVo = new TmLogVo();
		entity = tmLogService.get(TmLogEntity.class, entity.getId());
		try {
			MyBeanUtils.copyBeanNotNull2Bean(entity, tmLogVo);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return tmLogVo;
	}
	
}
