package com.biz.eisp.login.controller;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import com.biz.eisp.base.common.util.*;
import com.biz.eisp.base.utils.SysConfigUtils;
import com.biz.eisp.mdm.dict.util.DictUtil;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.core.web.BaseController;
import com.biz.eisp.login.service.JumpMainExtendService;
import com.biz.eisp.login.service.LoginService;
import com.biz.eisp.mdm.customer.entity.TmCustomerEntity;
import com.biz.eisp.mdm.function.service.MenuPermissionService;
import com.biz.eisp.mdm.function.vo.TmFunctionVo;
import com.biz.eisp.mdm.user.entity.TmUserEntity;
import com.biz.eisp.mdm.user.service.TmUserService;
import com.biz.eisp.mdm.user.vo.TmUserVo;
import com.biz.eisp.mdm.web.pojo.Client;
/**
 * 登录控制器类.
 * <p>登录相关访问项
 * @author grover
 * @version v1.0
 */
@Controller
@RequestMapping("/loginController")
public class LoginController extends BaseController{
	/**
	 * 登录服务层.
	 */
	@Autowired
	private LoginService loginService;
	/**
	 * 菜单权限服务层.
	 */
	@Autowired
	private MenuPermissionService menuPermissionService;
	/**
	 * 用户服务层.
	 */
	@Autowired
	private TmUserService tmUserService;
	/**
	 * 跳转主页扩展.
	 */
	@Autowired(required = false)
	private JumpMainExtendService jumpMainExtendService;

	@Autowired
	private SysConfigUtils sysConfigUtils;
	
	/**
	 * 登录验证.
	 * <p>登录时验证用户名和密码方法
	 * @param tmUserEntity 用户对象
	 * @param request 请求对象
	 * @return AjaxJson请求返回模型
	 */
	@RequestMapping(value="validateUser", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson validateUser(TmUserEntity tmUserEntity,HttpServletRequest request,HttpServletResponse response,
								 Boolean  rememberUserName,Boolean  rememberPassword) {
		AjaxJson j = new AjaxJson();
		j.setMsg("验证成功");
		try {
			//检测登录单点问题
			Client client = ResourceConfigUtils.getClientForLogin();
			if (client != null) {
				TmUserEntity login = client.getUser();
				if (login != null && StringUtils.isNotBlank(login.getUserName()) &&
						!login.getUserName().equals(tmUserEntity.getUserName())) {
					j.setSuccess(false);
					j.setMsg("该浏览器已经登录过账号:" + login.getUserName() + ",请先退出再登录其它账号");
					return j;
				}
			}
			//验证
			j = loginService.validateUser(tmUserEntity, Globals.N, Globals.N, request);
			setRememberUserNameAndPassword( tmUserEntity, rememberUserName,rememberPassword, response);
		}catch (BusinessException e){
			j.setSuccess(false);
			j.setMsg("登录认证缓存失败请重新尝试!");
		} catch (Exception e) {
			j.setSuccess(false);
			j.setMsg("服务器异常");
			e.printStackTrace();
			throw new BusinessException("登录失败，服务器异常");
		}
		return j;
	}
	/**
	 * 登录.
	 * <p>验证完成后进行登录操作
	 * @param tmUserEntity 用户对象
	 * @param request 请求对象
	 * @return 1.未登录或者缺少用户名、密码－跳转登录页面  2.登录成功－跳转主页面
	 */
	@RequestMapping(value="login", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView login(TmUserEntity tmUserEntity,HttpServletRequest request) {
		AjaxJson j = new AjaxJson();
		ModelAndView modelAndView = new ModelAndView();
		try {
			//用户名及密码验证
			if (StringUtils.isEmpty(tmUserEntity.getUserName()) || StringUtils.isEmpty(tmUserEntity.getPassword())) {
				modelAndView.setViewName("login/login");
				return modelAndView;
			}
			//验证并保存登录信息
			j = loginService.validateUser(tmUserEntity, Globals.Y, Globals.N, request);
			//跳转页面
			if (j.isSuccess()) {
				//查询用户信息
				HttpSession session = ContextHolderUtils.getSession();
				request.getSession().setAttribute("sessionId", session.getId());
				request.getSession().setMaxInactiveInterval(14400);//session4个小时失效
				TmUserVo userVo = new TmUserVo();
				userVo.setUserName(tmUserEntity.getUserName());
				userVo = tmUserService.getTmUser(userVo);
				//step1.首次登录修改密码
				if (hasFirstChangePwdView(userVo) && !"admin".equalsIgnoreCase(userVo.getUserName())) {
					modelAndView.setViewName("login/loginFirst");
					modelAndView.addObject("tmUserVo", userVo);
					return modelAndView;
				}
				//step2.页面路径跳转
				if (userVo.getUserType() == Globals.CUST_USER) {
					//跳转到经销商首页
					if (StringUtils.isNotBlank(userVo.getCustCode())) {
						//保存用户和客户的关系
						TmCustomerEntity customerEntity = new TmCustomerEntity();
						customerEntity.setId(userVo.getCustId());
						customerEntity.setCustomerCode(userVo.getCustCode());
						customerEntity.setErpCode(userVo.getErpCode());
						customerEntity.setCustomerName(userVo.getCustName());
						Client client = ResourceConfigUtils.getClient();
						client.setCustomerEntity(customerEntity);
						ResourceConfigUtils.setClient(client);
						//String customerIndexPage= ResourceUtil.getSysConfigProperty("customerIndexPage");
						String customerIndexPage= sysConfigUtils.getCustomerIndexPage();
						request.getSession().setAttribute("customer", customerEntity);
						if (StringUtil.isNotEmpty(jumpMainExtendService)){
							if (jumpMainExtendService.isToCustomerJump(tmUserEntity, userVo)){
								customerIndexPage=jumpMainExtendService.afterToJumpMain(tmUserEntity, userVo,request);
							}
						}
						modelAndView.setViewName(StringUtils.isNotBlank(customerIndexPage) ? customerIndexPage : "login/errorCustomerIndex");
					} else {
						modelAndView.setViewName("login/login");
					}
				} else {
					//跳转主界面扩展
					if (StringUtil.isNotEmpty(jumpMainExtendService)) {
						jumpMainExtendService.beforeJumpMain(tmUserEntity, userVo);
					}
					String title = DictUtil.getDicDataValue("main_title", "title");
					request.setAttribute("title", StringUtils.isNotBlank(title) ? title : "博智信息");

					String maintitle = DictUtil.getDicDataValue("main_title", "maintitle");
					request.setAttribute("maintitle", StringUtils.isNotBlank(maintitle) ? maintitle : "EISP CRM营销管理系统");
					//存储参数
					request.setAttribute("userVo", userVo);
					modelAndView.setViewName("main/main");
				}
				return modelAndView;
			} else {
				modelAndView.setViewName("login/login");
				return modelAndView;
			}
		}catch (BusinessException e){
			modelAndView.setViewName("login/login");
			request.setAttribute("showError",e.getMessage());
			return modelAndView;
		} catch (Exception e) {
			e.printStackTrace();
			modelAndView.setViewName("login/login");
			return modelAndView;
		}
	}
	
	/**
	 * 登录接口-对外.
	 * <p>验证完成后进行登录操作
	 * @param tmUserEntity 用户对象
	 * @param request 请求对象
	 * @return 1.未登录或者缺少用户名、密码－跳转登录页面  2.登录成功－跳转主页面
	 */
	@RequestMapping(value = "apiLogin",method = {RequestMethod.GET,RequestMethod.POST})
	public ModelAndView apiLogin(TmUserEntity tmUserEntity,HttpServletRequest request) {
		AjaxJson j = new AjaxJson();
		ModelAndView modelAndView = new ModelAndView();
		//获取是否加密参数
		String isEncryption = OConvertUtils.getString(request.getParameter("isEncryption"));
		if(StringUtil.isEmpty(isEncryption)){
			isEncryption = Globals.N;
		}
		try {
			//用户名及密码验证
			if (StringUtils.isEmpty(tmUserEntity.getUserName())||StringUtils.isEmpty(tmUserEntity.getPassword())) {
				modelAndView.setViewName("login/login");
				return modelAndView;
			}
			//验证并保存登录信息
			j = loginService.validateUser(tmUserEntity,Globals.Y,isEncryption,request);
			//跳转页面
			if(j.isSuccess()){
				//查询用户信息
				HttpSession session = ContextHolderUtils.getSession();
				request.getSession().setAttribute("sessionId", session.getId());
				TmUserVo userVo = new TmUserVo();
				userVo.setUserName(tmUserEntity.getUserName());
				userVo = tmUserService.getTmUser(userVo);
				//step1.首次登录修改密码
				if (hasFirstChangePwdView(userVo) && !"admin".equalsIgnoreCase(userVo.getUserName())) {
					modelAndView.setViewName("login/loginFirst");
					modelAndView.addObject("tmUserVo", userVo);
					return modelAndView;
				}
				//step2.页面路径跳转
				if (userVo.getUserType()==Globals.CUST_USER) {
					//跳转到经销商首页
					if (StringUtils.isNotBlank(userVo.getCustCode())) {
						//保存用户和客户的关系
						TmCustomerEntity customerEntity = new TmCustomerEntity();
						customerEntity.setId(userVo.getCustId());
						customerEntity.setCustomerCode(userVo.getCustCode());
						customerEntity.setErpCode(userVo.getErpCode());
						customerEntity.setCustomerName(userVo.getCustName());
						Client client = ResourceConfigUtils.getClient();
						client.setCustomerEntity(customerEntity);
						ResourceConfigUtils.setClient(client);
						//String customerIndexPage = ResourceUtil.getSysConfigProperty("customerIndexPage");
						String customerIndexPage = sysConfigUtils.getCustomerIndexPage();
						request.setAttribute("customer", customerEntity);
						modelAndView.setViewName(StringUtils.isNotBlank(customerIndexPage) ? customerIndexPage : "login/errorCustomerIndex");
					}else{
						modelAndView.setViewName("login/login");
					}
				}else{
					//跳转主界面扩展
					if (StringUtil.isNotEmpty(jumpMainExtendService)) {
						jumpMainExtendService.beforeJumpMain(tmUserEntity, userVo);
					}
					//存储参数
					request.setAttribute("userVo", userVo);
					modelAndView.setViewName("main/main");
				}
				return modelAndView;
			}else{
				modelAndView.setViewName("login/login");
				return modelAndView;
			}
		} catch (Exception e) {
			modelAndView.setViewName("login/login");
			return modelAndView;
		}
	}
	
	/**
	 * 是否第一次登录.
	 * @author grover
	 * @param tmUserVo
	 * 		用户对象
	 * @return
	 * 		是否第一次登录 true-是 false-否
	 */
	private boolean hasFirstChangePwdView(TmUserVo tmUserVo) {
		//获取是否开启第一次登录修改密码
		//String hasFirstTimeChange = ResourceUtil.getSysConfigProperty("hasFirstTimeChange");
		String hasFirstTimeChange = sysConfigUtils.getHasFirstTimeChange();
		if (StringUtil.isNotEmpty(hasFirstTimeChange)
				&& hasFirstTimeChange.equalsIgnoreCase(Globals.ENABLE)) {
			if (StringUtil.isEmpty(tmUserVo.getHasFirstTime())
					||(StringUtil.isNotEmpty(tmUserVo.getHasFirstTime()) && tmUserVo.getHasFirstTime() == Globals.YES) ) {
				return true;
			}
		}
		return false;
	}
	
	/**
	 * 主界面左侧.
	 * <p>主界面左侧跳转方法<br>
	 * @param request 请求对象
	 * @return 跳转左侧界面
	 */
	@RequestMapping(value="left", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView left(HttpServletRequest request) {
		//获取session信息
		HttpSession session = ContextHolderUtils.getSession();
		Client client = ResourceConfigUtils.getClient();
		TmUserEntity tmUserEntity = client.getUser();
		ModelAndView modelAndView = new ModelAndView();
		// 登陆者的权限
        if (tmUserEntity.getId() == null) {
            session.removeAttribute(Globals.USER_SESSION);
            modelAndView.setViewName("login/login");
        }else{
        	request.setAttribute("menuPermissionMap", getFunctionLevelMap(tmUserEntity));
            modelAndView.setViewName("main/left");
        }
		return modelAndView;
	}
	/**
	 * 菜单权限.
	 * <p>获取菜单权限集合请求方法
	 * @param tmUserEntity 用户对象
	 * @return 权限菜单map集合以菜单层级作为key
	 */
    private Map<Integer, List<TmFunctionVo>> getFunctionLevelMap(TmUserEntity tmUserEntity) {
        Map<Integer, List<TmFunctionVo>> functionMap = new HashMap<Integer, List<TmFunctionVo>>();
        //获取权限
        Map<String, TmFunctionVo> functionsMap = getFucntionsByUser(tmUserEntity);
        if (functionsMap.size() > 0) {
            Collection<TmFunctionVo> allFunctions = functionsMap.values();
            for (TmFunctionVo function : allFunctions) {
                if (!functionMap.containsKey(function.getFunctionLevel() + 0)) {
                    functionMap.put(function.getFunctionLevel() + 0, new ArrayList<TmFunctionVo>());
                }
                functionMap.get(function.getFunctionLevel() + 0).add(function);
            }
            // 菜单栏排序
            Collection<List<TmFunctionVo>> tmFunction = functionMap.values();
            for (List<TmFunctionVo> list : tmFunction) {
            	Collections.sort(list);
            }
        }
        return functionMap;
    }
	/**
	 * 权限.
	 * <p>获取菜单权限集合请求方法
	 * @param tmUserEntity 用户对象
	 * @return 权限map集合，以菜单主键作为key
	 */
	private Map<String, TmFunctionVo> getFucntionsByUser(TmUserEntity tmUserEntity) {
		//返回对象
		Map<String, TmFunctionVo> map = new HashMap<String,TmFunctionVo>();
		//获取session信息
		Client client = ResourceConfigUtils.getClient();
		//获取缓存的权限信息 没有获取到则实时查询
		if(client.getFunctions()!=null&&client.getFunctions().size()>0){
			map.putAll(client.getFunctions());
		}else{
			//查询权限信息
			List<TmFunctionVo> tmFunctions = menuPermissionService.getFunctionsByUser(tmUserEntity);
			//封装数据
			if(tmFunctions.size()>0){
				for (TmFunctionVo tmFunctionVo : tmFunctions) {
					map.put(tmFunctionVo.getId() , tmFunctionVo);
				}
			}
		}
		return map;
	}
	/**
	 * 主界面.
	 * <p>主界面页面跳转
	 * @param request 请求对象
	 * @return 跳转主界面页面
	 */
	@RequestMapping(value = "home", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView home(HttpServletRequest request) {
		return new ModelAndView("main/home");
	}
	/**
	 * 无权限.
	 * <p>无权限时跳转页面的请求方法
	 * @param request 请求对象
	 * @return 跳转无权限页面
	 */
    @RequestMapping(value = "noPermisson", method = {RequestMethod.GET, RequestMethod.POST})
    public ModelAndView noPermisson(HttpServletRequest request) {
        return new ModelAndView("common/noPermisson");
    }
    
    /**
     * 无需进入登录页面访问系统(演示用)	
     */
	@RequestMapping(value="nonLoginAccess", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView nonLoginAccess(HttpServletRequest request) {
		ModelAndView modelAndView = new ModelAndView();
		TmUserEntity tmUserEntity=new TmUserEntity();
		tmUserEntity.setUserName("admin");
		tmUserEntity.setPassword("123456");
		AjaxJson j = loginService.validateUser(tmUserEntity,Globals.Y,Globals.N,request);
		HttpSession session = ContextHolderUtils.getSession();
		request.getSession().setAttribute("sessionId", session.getId());
		TmUserVo userVo = new TmUserVo();
		userVo.setUserName(tmUserEntity.getUserName());
		userVo = tmUserService.getTmUser(userVo);
		request.setAttribute("userVo", userVo);
		modelAndView.setViewName("main/main");
		return modelAndView;
	}
    
    /**
     * 退出系统.
     * @param request 请求对象
     * @return 跳转登录页面
     */
    @RequestMapping(value = "logout", method = {RequestMethod.GET, RequestMethod.POST})
    public ModelAndView logout(HttpServletRequest request) {
    	HttpSession session = ContextHolderUtils.getSession();
//		ResourceUtil.clientMap.remove(session.getId());//清除本地map
		ResourceConfigUtils.setClient(new Client());
		session.removeAttribute(session.getId());
    	return new ModelAndView("login/login");
    }

	/***
	 * 设置 账号密码 cookie
	 * @param tmUserEntity
	 * @param rememberUserName
	 * @param rememberPassword
	 * @param response
	 */
    public void setRememberUserNameAndPassword(TmUserEntity tmUserEntity,Boolean rememberUserName,
											   Boolean rememberPassword,HttpServletResponse response){
		Cookie cookie=null;
		if(rememberUserName){
			cookie=new Cookie("rememberUserName",tmUserEntity.getUserName());
			/**过期时间五年*/
			cookie.setMaxAge(5*365*24*60*60);
			response.addCookie(cookie);
		}else {
			cookie=new Cookie("rememberUserName",null);
			cookie.setMaxAge(0); //立即删除型
			cookie.setPath("/"); //项目所有目录均有效，这句很关键，否则不敢保证删除
			response.addCookie(cookie); //重新写入，将覆盖之前的
		}
		if(rememberPassword){
			cookie=new Cookie("rememberPassword",tmUserEntity.getPassword());
			/**过期时间五年*/
			cookie.setMaxAge(5*365*24*60*60);
			response.addCookie(cookie);
		}else {
			cookie=new Cookie("rememberPassword",null);
			cookie.setMaxAge(0); //立即删除型
			cookie.setPath("/"); //项目所有目录均有效，这句很关键，否则不敢保证删除
			response.addCookie(cookie); //重新写入，将覆盖之前的
		}
	}
}
