package com.biz.eisp.login.service;

import com.biz.eisp.mdm.user.entity.TmUserEntity;
import com.biz.eisp.mdm.user.vo.TmUserVo;

import javax.servlet.http.HttpServletRequest;

/**
 * 跳转主页扩展.
 * <p>跳转主页扩展接口service.<br>
 * 提供了登录成功后跳转主页扩展接口,供项目组使用
 * @author grover
 * @version v1.0
 */
public interface JumpMainExtendService {
	/**
	 * 跳转主页之前.
	 * <p>登录之后跳转主页的接口扩展方法
	 * @param tmUserEntity 用户对象
	 * @param tmUserVo 用户vo对象
	 * @return
	 */
	void beforeJumpMain(TmUserEntity tmUserEntity, TmUserVo tmUserVo);

	/**
	 * 自己定义跳转
	 * @param tmUserEntity
	 * @param tmUserVo
	 */
	String afterToJumpMain(TmUserEntity tmUserEntity, TmUserVo tmUserVo, HttpServletRequest request);

	/**
	 * 是否开始自定义跳转方法 afterToJumpMain
	 * @return
	 */
	boolean isToCustomerJump(TmUserEntity tmUserEntity, TmUserVo tmUserVo);
}
