package com.biz.eisp.login.service;

import javax.servlet.http.HttpServletRequest;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.core.service.BaseService;
import com.biz.eisp.mdm.position.vo.TmPositionVo;
import com.biz.eisp.mdm.user.entity.TmUserEntity;
/**
 * 登录.
 * <p>该类定义了登录的常见接口
 * @author grover
 * @version v1.0
 */
public interface LoginService extends BaseService{
	 /**
	  * 检查.
	  * <p>检查用户是否可用
	  * @author grover
	  * @param tmUserEntity 用户实体
	  * @param flag 是否保存用户信息 N-否 Y-是
	  * @param isEncryption 是否密码已经加密 Y-加密 N-未加密
	  * @param request 请求信息
	  * @return AjaxJson返回模型
	  */
     AjaxJson validateUser(TmUserEntity tmUserEntity,String flag,String isEncryption,HttpServletRequest request);
     /**
      * 保存用户信息.
      * <p>登录成功之后，保存用户信息到会话中
      * @author grover
      * @param tmUserEntity 用户对象
      * @param positionEntity 职位实体
      * @param request 请求对象
      */
     void saveLoginInfo(TmUserEntity tmUserEntity,
    		TmPositionVo positionVo, HttpServletRequest request);
}
