package com.biz.eisp.login.service;

import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import com.biz.eisp.mdm.user.entity.TmUserEntity;
import com.biz.eisp.mdm.web.pojo.Client;

/**
 * 登录扩展.
 * <p>登录扩展接口service.<br>
 * 提供了登录之前和登录之后的扩展接口,供项目组使用
 * @author grover
 * @version v1.0
 */
public interface LoginrRelatedService {
	/**
	 * 登录之前.
	 * <p>登录之前的接口扩展方法
	 * @param tmUserEntity 用户对象
	 * @param request 请求对象
	 * @return 二次开发自行封装的map集合
	 */
	 Map<String, Object> beforeLoginIn(
			 TmUserEntity tmUserEntity, HttpServletRequest request);
	/**
	 * 登录之后.
	 * <p>登录之后的接口扩展方法<br>
	 * @param tmUserEntity 用户对象
	 * @param request 请求对象
	 * @return 二次开发自行封装的map集合
	 */
	 Map<String, Object> afterLoginIn(
			 TmUserEntity tmUserEntity, HttpServletRequest request);

	/**
	 * 是否需要去获取组织
	 * @return
	 */
	boolean isToGetOrg();
}
