package com.biz.eisp.login.service.impl;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.*;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.base.utils.SysConfigUtils;
import com.biz.eisp.login.service.LoginService;
import com.biz.eisp.login.service.LoginrRelatedService;
import com.biz.eisp.login.service.PasswdService;
import com.biz.eisp.mdm.custorg.entity.TmCustomerOrgEntity;
import com.biz.eisp.mdm.org.entity.TmOrgEntity;
import com.biz.eisp.mdm.position.service.PositionService;
import com.biz.eisp.mdm.position.vo.TmPositionVo;
import com.biz.eisp.mdm.user.entity.TmUserEntity;
import com.biz.eisp.mdm.web.pojo.Client;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import java.util.Date;
import java.util.List;
/**
 * 登录接口实现.
 * <p>该类为登录接口的实现实现类
 * @author grover
 * @version v1.0
 */
@Service("loginService")
@Transactional
public class LoginServiceImpl extends BaseServiceImpl implements LoginService {
	/**
	 * 职位相关服务层.
	 */
	@Autowired
	private PositionService positionService;
	/**
	 * 登录扩展服务层.
	 */
	@Autowired(required = false)
	private LoginrRelatedService loginrRelatedService;
	/**
	 * 密码加密扩展
	 */
	@Autowired(required = false)
	private PasswdService passwdService;

	@Autowired
	private SysConfigUtils sysConfigUtils;
	/**
	  * 检查实现.
	  * <p>检查用户是否可用的接口实现类
	  * @param tmUserEntity 用户实体
	  * @param flag 是否保存用户信息 N-否 Y-是
	  * @param isEncryption 是否密码已经加密 true-加密 false未加密
	  * @param request 请求信息
	  * @return AjaxJson返回模型
	  */
	@Override
	public AjaxJson validateUser(
			TmUserEntity tmUserEntity,
			String flag,String isEncryption,
			HttpServletRequest request) {
		String hql = "from TmUserEntity where userName = ? ";
		//登录扩展
		if (loginrRelatedService != null) {
			loginrRelatedService.beforeLoginIn(
					tmUserEntity, request);
		}
		//返回对象
		AjaxJson j = new AjaxJson();
		//验证用户
		List<TmUserEntity> list = super.findByHql(hql,
			tmUserEntity.getUserName());
		//处理返回
		if (list.size() > 0) {
			TmUserEntity userEntity = list.get(0);
			//校验是否被锁定
			if (Globals.User_Forbidden == userEntity.getEnableStatus()
			&& !Globals.Admin_Name.equalsIgnoreCase(
				userEntity.getUserName())) {
				j.setSuccess(false);
				j.setMsg("用户账号锁定,请联系管理员");
				return j;
			}
			//处理密码
			String pwd = tmUserEntity.getPassword();
			if(Globals.N.equalsIgnoreCase(isEncryption)){
				if (passwdService != null && passwdService.isExtend(userEntity)){
					pwd=passwdService.pwd(pwd);
				}else {
					pwd = Md5EncryptionAndDecryption.encryPwd(pwd);
				}
			}
			//验证密码是否正确
			if(!pwd.equals(userEntity.getPassword())){
				//String configLoginErrTimes = ResourceUtil.getSysConfigProperty("loginErrTimes");
				String configLoginErrTimes = sysConfigUtils.getLoginErrTimes();
				if(StringUtil.isNotBlank(configLoginErrTimes)) {
					short configLoginErrTimesShort = Short.parseShort(configLoginErrTimes);
					Short loginErrTimes = userEntity.getLoginErrTimes()==null?0:userEntity.getLoginErrTimes();
					//判断loginErrTimes是否>3
					if(loginErrTimes >= configLoginErrTimesShort){
						//如果大于3则锁定用户
						String sql="update tm_user set enable_status=?,update_date=sysdate where id=?";
						executeSql(sql, Globals.User_Forbidden, userEntity.getId());
					}else{
						//如果小于3失败次数加1
						loginErrTimes++;
						String sql="update tm_user set login_err_times=?,update_date=sysdate where id=?";
						executeSql(sql, loginErrTimes, userEntity.getId());
					}
					if(loginErrTimes == configLoginErrTimesShort){
						j.setMsg("用户名或者密码错误！用户："+userEntity.getUserName()+"被锁定！");
					}else{
						j.setMsg("用户名或者密码错误！您还有"+(configLoginErrTimesShort - loginErrTimes)+"次机会尝试");
					}
				} else {
					j.setMsg("用户名或者密码错误！");
				}
				j.setSuccess(false);
				return j;
			}else{
				//登陆成功，把失败次数设置为0
				String sql="update tm_user set login_err_times=?,update_date=sysdate where id=?";
				executeSql(sql, Globals.User_Normal, userEntity.getId());
			}
			//校验主职位
			List<TmPositionVo> positions = positionService
					.getPositinByUserId(
					userEntity, Globals.Main_Position_Type);
			if (positions.size() == 0
					&& userEntity.getUserType()==Globals.ENTERPRISE_USER) {
				j.setSuccess(false);
				j.setMsg("用户未分配主职位,请联系管理员");
				return j;
			}else{
				if(userEntity.getUserType()==Globals.ENTERPRISE_USER){
					TmPositionVo tmPositionVo = positions.get(0);
					if(Globals.ONE.equals(tmPositionVo.getEnableStatus())){
						j.setSuccess(false);
						j.setMsg("用户所属主职位被停用,请联系管理员");
						return j;
					}
				}
			}
			
			//保存登录信息
			if (Globals.Y.equalsIgnoreCase(flag)) {
			//if (Globals.Y.equalsIgnoreCase("Y")) {
				TmPositionVo positionVo = new TmPositionVo();
				if (CollectionUtil.listNotEmptyNotSizeZero(positions)) {
					positionVo = positions.get(0);
				}
				saveLoginInfo(userEntity, positionVo, request);
			}
			//登录扩展
			if (loginrRelatedService != null) {
				loginrRelatedService
					.afterLoginIn(userEntity, request);
			}
		} else {
			j.setSuccess(false);
			j.setMsg("用户名或者密码错误！");
			return j;
		}
		return j;
	}
	 /**
     * 保存用户信息实现.
     * <p>登录成功之后，保存用户信息到会话中的接口实现
     * @param tmUserEntity 用户对象
     * @param request 请求对象
     */
	@SuppressWarnings("deprecation")
	@Override
	public void saveLoginInfo(TmUserEntity tmUserEntity, TmPositionVo tmPositionVo, HttpServletRequest request) {
		//验证通过之后保存session信息
		HttpSession session = ContextHolderUtils.getSession();
		Client client = new Client();
        client.setIp(IpUtil.getIpAddr(request));
        client.setLogindatetime(new Date());
        client.setUser(getUser(tmUserEntity));
        client.setPosition(tmPositionVo);

        boolean b=false;
		if (loginrRelatedService != null&&loginrRelatedService.isToGetOrg()) {
			b=true;
		}
        //企业用户信息
        if(Globals.ENTERPRISE_USER==tmUserEntity.getUserType()||b){
        	//组织
        	if(StringUtil.isNotEmpty(tmPositionVo.getOrgId())){
        		TmOrgEntity orgEntity=this.get(TmOrgEntity.class, tmPositionVo.getOrgId());
                client.setOrg(getTmOrgEntity(orgEntity));
        	}
            //客户组织
            TmCustomerOrgEntity customerOrg=
            		findUniqueByProperty(TmCustomerOrgEntity.class, "positionId", tmPositionVo.getId());
        	if (customerOrg!=null)
            client.setCustomerOrg(getTmCustomerOrgEntity(customerOrg));
        }
        //实例管理对象
		ResourceConfigUtils.setClient(client);
	}

	private TmCustomerOrgEntity getTmCustomerOrgEntity(TmCustomerOrgEntity org){
		TmCustomerOrgEntity result=new TmCustomerOrgEntity();
		result.setId(org.getId());
		result.setHeadString(org.getHeadString());
		result.setEnableStatus(org.getEnableStatus());
		result.setCreateDate(org.getCreateDate());
		result.setCreateName(org.getCreateName());
		result.setUpdateDate(org.getUpdateDate());
		result.setUpdateName(org.getUpdateName());
		result.setExtChar1(org.getExtChar1());
		result.setExtChar2(org.getExtChar2());
		result.setExtChar3(org.getExtChar3());
		result.setExtChar4(org.getExtChar4());
		result.setExtChar5(org.getExtChar5());
		result.setExtNumber1(org.getExtNumber1());
		result.setExtNumber2(org.getExtNumber2());
		result.setExtNumber3(org.getExtNumber3());
		result.setIsLeaf(org.getIsLeaf());
		result.setCustOrgCode(org.getCustOrgCode());
		result.setCustomerOrgName(org.getCustomerOrgName());
		result.setCustOrgDesc(org.getCustOrgDesc());
		result.setCustOrgType(org.getCustOrgType());
		result.setCustOrgLevel(org.getCustOrgLevel());
		result.setPositionId(org.getPositionId());

		return result;
	}
	private TmOrgEntity getTmOrgEntity(TmOrgEntity org){
		TmOrgEntity result=new TmOrgEntity();
		result.setId(org.getId());
		result.setOrgName(org.getOrgName());
		result.setOrgDesc(org.getOrgDesc());
		result.setOrgCode(org.getOrgCode());
		result.setOrgType(org.getOrgType());
		result.setHeadString(org.getHeadString());
		result.setSubCode(org.getSubCode());
		result.setEnableStatus(org.getEnableStatus());
		result.setCreateDate(org.getCreateDate());
		result.setCreateName(org.getCreateName());
		result.setUpdateDate(org.getUpdateDate());
		result.setUpdateName(org.getUpdateName());
		result.setStatus(org.getStatus());
		result.setExtChar1(org.getExtChar1());
		result.setExtChar2(org.getExtChar2());
		result.setExtChar3(org.getExtChar3());
		result.setExtChar4(org.getExtChar4());
		result.setExtChar5(org.getExtChar5());
		result.setExtNumber1(org.getExtNumber1());
		result.setExtNumber2(org.getExtNumber2());
		result.setExtNumber3(org.getExtNumber3());
		result.setExtDate1(org.getExtDate1());
		result.setExtDate2(org.getExtDate2());
		result.setIsLeaf(org.getIsLeaf());
		return  result;
	}
	private TmUserEntity getUser(TmUserEntity tmUserEntity){
		TmUserEntity rt=new TmUserEntity();
		rt.setId(tmUserEntity.getId());
		rt.setUserName(tmUserEntity.getUserName());
		rt.setFullName(tmUserEntity.getFullName());
		rt.setExtChar7(tmUserEntity.getExtChar7());
		rt.setSex(tmUserEntity.getSex());
		rt.setMobilePhone(tmUserEntity.getMobilePhone());
		rt.setEmail(tmUserEntity.getEmail());
		rt.setPassword(tmUserEntity.getPassword());
		rt.setEnableStatus(tmUserEntity.getEnableStatus());
		rt.setHeadString(tmUserEntity.getHeadString());
		rt.setHasFirstTime(tmUserEntity.getHasFirstTime());
		rt.setCreateDate(tmUserEntity.getCreateDate());
		rt.setCreateName(tmUserEntity.getCreateName());
		rt.setUpdateDate(tmUserEntity.getUpdateDate());
		rt.setUpdateName(tmUserEntity.getUpdateName());
		rt.setUserType(tmUserEntity.getUserType());
		rt.setBeginDate(tmUserEntity.getBeginDate());
		rt.setEndDate(tmUserEntity.getEndDate());
		rt.setLoginErrTimes(tmUserEntity.getLoginErrTimes());
		rt.setExtChar1(tmUserEntity.getExtChar1());
		rt.setExtChar2(tmUserEntity.getExtChar2());
		rt.setExtChar3(tmUserEntity.getExtChar3());
		rt.setExtChar4(tmUserEntity.getExtChar4());
		rt.setExtChar5(tmUserEntity.getExtChar5());
		rt.setExtChar6(tmUserEntity.getExtChar6());
		rt.setExtChar7(tmUserEntity.getExtChar7());
		rt.setExtChar8(tmUserEntity.getExtChar8());
		rt.setExtChar9(tmUserEntity.getExtChar9());
		rt.setExtChar10(tmUserEntity.getExtChar10());
		rt.setExtNumber1(tmUserEntity.getExtNumber1());
		rt.setExtNumber2(tmUserEntity.getExtNumber2());
		rt.setExtNumber3(tmUserEntity.getExtNumber3());
		rt.setExtDate1(tmUserEntity.getExtDate1());
		rt.setExtDate2(tmUserEntity.getExtDate2());
	    return  rt;
	}
}
