package com.biz.eisp.mdm.actrole.controller;

import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.util.OConvertUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.EuPage;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.web.BaseController;
import com.biz.eisp.mdm.actrole.service.TmActRoleService;
import com.biz.eisp.mdm.actrole.vo.TmActRoleVo;

/**
 * 工作流角色Controller.
 * <p>
 * 
 * @author liukai
 * @version v1.0
 */
@Controller
@RequestMapping("/tmActRoleController")
public class TmActRoleController extends BaseController {

	@Autowired
	private TmActRoleService tmActRoleService;

	@RequestMapping(value = "findActRoleList", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public DataGrid findActRoleList(TmActRoleVo tmActRoleVo, HttpServletRequest request, HttpServletResponse response) {
		Page page = new EuPage(request);
		List <TmActRoleVo> voList = tmActRoleService.findActRoleList(tmActRoleVo, page);
		return new DataGrid(voList, page);
	}
	
	/**
	 * 跳转工作流角色.
	 * @author grover
	 * @param tmActRoleVo 角色vo.
	 * @param request 请求对象.
	 * @return 工作流角色路径
	 */
	@RequestMapping(value = "goTmActRoleMain", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goTmActRoleMain(TmActRoleVo tmActRoleVo, HttpServletRequest request) {
		if(StringUtil.isNotEmpty(tmActRoleVo.getId())){
			request.setAttribute("posId", tmActRoleVo.getId());
		}
		return new ModelAndView("com/biz/eisp/mdm/role/tmActRoleMain");
	}
	/**
	 * 跳转选中工作流角色.
	 * @author grover
	 * @param tmActRoleVo 角色vo.
	 * @param request 请求对象.
	 * @return 选中工作流角色路径
	 */
	@RequestMapping(value = "goTmActRoleCheckedMain", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goTmActRoleCheckedMain(TmActRoleVo tmActRoleVo, HttpServletRequest request) {
		if(StringUtil.isNotEmpty(tmActRoleVo.getPosId())){
			request.setAttribute("posId", tmActRoleVo.getPosId());
		}else{
			request.setAttribute("posId", "-1");
		}
		return new ModelAndView("com/biz/eisp/mdm/role/tmActRoleCheckedMain");
	}
	/**
	 * 获取工作流角色.
	 * @author grover
	 * @param tmActRoleVo 角色vo.
	 * @param response 响应对象
	 * @return 工作流角色
	 */
	@RequestMapping(value = "findActRoleMain", method = {RequestMethod.GET, RequestMethod.POST})
	public void findActRoleMain(TmActRoleVo tmActRoleVo, HttpServletRequest request, HttpServletResponse response) {
		//是否分页
		Page page = new EuPage(request);
		String pagination = OConvertUtils.getString(request.getParameter("pagination"));
		if(StringUtil.isNotEmpty(pagination)){
			page = null;
		}
		List <TmActRoleVo> voList = tmActRoleService.findActRoleByPositionMain(tmActRoleVo, page);
		if(StringUtil.isNotEmpty(pagination)){
			this.datagridReturn(response, voList);
		}else{
			this.datagridReturn(response, voList, page);
		}
	}
}
