package com.biz.eisp.mdm.actrole.dao;

import java.util.List;

import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.interfacedao.annotation.Arguments;
import com.biz.eisp.base.interfacedao.annotation.InterfaceDao;
import com.biz.eisp.base.interfacedao.annotation.ResultType;
import com.biz.eisp.mdm.actrole.vo.TmActRoleVo;
import com.biz.eisp.mdm.position.vo.TmPositionVo;

/** 类简述.
 * <p>类的详细说明第一行<br>
 * 类的详细说明第二行
 * @author liukai
 * @version v1.0
 */
@InterfaceDao
public interface TmActRoleDao {

	/**
	 * 查询工作流角色，该角色下的职位的所属组织为当前组织的列表信息.
	 * <p>
	 * 筛选数据逻辑：<br>
	 * 1.查询工作流角色（=actRoleCode）下的职位 <br>
	 * 2.查询步骤1的职位信息的所属组织<br>
	 * 3.筛选出步骤2中的组织信息与当前组织ID（currOrgId）的组织信息<br>
	 * 4.查询出步骤3中的组织信息下的职位信息<br>
	 * 
	 * @param actRoleCode
	 *            工作流角色编码
	 * @param currOrgId
	 *            当前组织ID，系统操作者的组织ID
	 * @return
	 */
	@Arguments({"actRoleCode","currOrgId"})
	@ResultType(TmPositionVo.class)
	public List<TmPositionVo> findCurrOrgPositionList(String actRoleCode, String currOrgId);
	
	/**
	 * 查询工作流角色，该角色下的职位的所属组织及其下级组织为当前组织的列表信息.
	 * <p>
	 * 筛选数据逻辑：<br>
	 * 1.查询工作流角色（=actRoleCode）下的职位<br>
	 * 2.查询步骤1的职位信息的所属组织，及其所属组织的下级组织<br>
	 * 3.筛选出步骤2中的组织信息与当前组织ID（currOrgId）的组织信息<br>
	 * 4.查询出步骤3中的组织信息下的职位信息<br>
	 * 
	 * @param actRoleCode
	 *            工作流角色编码
	 * @param currOrgId
	 *            当前组织ID，系统操作者的组织ID
	 * @return
	 */
	@Arguments({"actRoleCode","currOrgId"})
	@ResultType(TmPositionVo.class)
	public List<TmPositionVo> findCurrAndSubOrgPositionList(String actRoleCode, String currOrgId);
	
	/**
	 * 查询当前组织及组织以下：
	 * 	逻辑：<br>
	 * 		1:查询工作流角色关系+工作流角色表+职位表
	 * 	    2:然后连接组织表，根据流程发起人的组织，找寻该组织下面所有的职位
	 * @param actRoleCode
	 * @param currOrgId
	 * @return
	 */
	@Arguments({"actRoleCode","currOrgId"})
	@ResultType(TmPositionVo.class)
	public List<TmPositionVo> findCurrAndBelowOrgPositionList(String actRoleCode, String currOrgId);
	/**
	 * 查询工作流角色，根据一些条件
	 * @author wan
	 * @param vo
	 * @return
	 */
	@Arguments({"vo","page"})
	@ResultType(TmActRoleVo.class)
	public List<TmActRoleVo> findActRoleByConditions(TmActRoleVo vo,Page page);
	/**
	 * 获取职位获取角色.
	 * @author grover
	 * @param vo 工作流角色vo
	 * @param page 
	 * @return 工作流角色集合
	 */
	@Arguments({"vo","page"})
	@ResultType(TmActRoleVo.class)
	public List<TmActRoleVo> findActRoleByPosition(TmActRoleVo vo,Page page);

	/**
	 * 查找负责该区域的负责人
	 * @param actRoleCode
	 * @param currOrgId
	 * @return
	 */
	@Arguments({"actRoleCode","currOrgId"})
	@ResultType(TmPositionVo.class)
	public List<TmPositionVo> findResponsibleArea(String actRoleCode, String currOrgId);

	@Arguments({"actRoleCode","parent"})
	@ResultType(TmPositionVo.class)
	public List<TmPositionVo> findParentPositionList(String actRoleCode, String parent);

	@Arguments({"actRoleCode","submitPositionId"})
	@ResultType(TmPositionVo.class)
	public List<TmPositionVo> findParentsPositionList(String actRoleCode, String submitPositionId);
	
	/**
	 * 根据角色查找职位列表.
	 * <p>
	 * @param actRoleCode
	 * @return
	 */
	@Arguments({"actRoleCode"}) 
	@ResultType(TmPositionVo.class)
	public List<TmPositionVo> findPositionList(String actRoleCode);
}
