package com.biz.eisp.mdm.actrole.entity;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

import com.biz.eisp.base.common.identity.IdEntity;

/**
 * 工作流角色表
 * 关联数据库表:TM_ACT_ROLE
 * @author wan
 * @version v1.0
 */
@Entity
@Table(name = "TM_ACT_ROLE")
public class TmActRoleEntity extends IdEntity implements Serializable {
	private static final long serialVersionUID = 1L;
	/**
	 * 角色名称
	 */
	private String roleName;
	/**
	 * 角色编码
	 */
	private String roleCode;
	/**
	 *  创建时间
	 */
	private Date createDate;
	/**
	 * 创建人
	 */
	private String createName;
	/**
	 * 修改时间
	 */
	private Date updateDate;
	/**
	 * 修改人
	 */
	private String updateName;
	/**
	 * 状态 0删除 1正常
	 */
	private Integer enableState;
	/**
	 *  角色名称拼音简写
	 */
	private String headString;

	/**
	 * 方法: 取得 java.lang.String
	 * 
	 * @return: java.lang.String 角色名称
	 */
	@Column(name = "role_name", nullable = false, length = 50)
	public String getRoleName() {
		return this.roleName;
	}

	/**
	 * 方法: 设置java.lang.String
	 * 
	 * @param: java.lang.String
	 *             角色名称
	 */
	public void setRoleName(String roleName) {
		this.roleName = roleName;
	}

	/**
	 * 方法: 取得 java.lang.String
	 * 
	 * @return: java.lang.String 角色编码
	 */
	@Column(name = "role_code", length = 30)
	public String getRoleCode() {
		return this.roleCode;
	}

	/**
	 * 方法: 设置java.lang.String
	 * 
	 * @param: java.lang.String
	 *             角色编码
	 */
	public void setRoleCode(String roleCode) {
		this.roleCode = roleCode;
	}

	/**
	 * 方法: 取得java.util.Date
	 * 
	 * @return: java.util.Date 创建时间
	 */
	@Column(name = "create_date", nullable = true)
	public Date getCreateDate() {
		return this.createDate;
	}

	/**
	 * 方法: 设置java.util.Date
	 * 
	 * @param: java.util.Date
	 *             创建时间
	 */
	public void setCreateDate(Date createDate) {
		this.createDate = createDate;
	}

	/**
	 * 方法: 取得java.lang.String
	 * 
	 * @return: java.lang.String 创建人
	 */
	@Column(name = "create_name", nullable = true, length = 32)
	public String getCreateName() {
		return this.createName;
	}

	/**
	 * 方法: 设置java.lang.String
	 * 
	 * @param: java.lang.String
	 *             创建人
	 */
	public void setCreateName(String createName) {
		this.createName = createName;
	}

	/**
	 * 方法: 取得java.util.Date
	 * 
	 * @return: java.util.Date 修改时间
	 */
	@Column(name = "update_date", nullable = true)
	public Date getUpdateDate() {
		return this.updateDate;
	}

	/**
	 * 方法: 设置java.util.Date
	 * 
	 * @param: java.util.Date
	 *             修改时间
	 */
	public void setUpdateDate(Date updateDate) {
		this.updateDate = updateDate;
	}

	/**
	 * 方法: 取得java.lang.String
	 * 
	 * @return: java.lang.String 修改人ID
	 */
	@Column(name = "update_name", nullable = true, length = 32)
	public String getUpdateName() {
		return this.updateName;
	}

	/**
	 * 方法: 设置java.lang.String
	 * 
	 * @param: java.lang.String
	 *             修改人ID
	 */
	public void setUpdateName(String updateName) {
		this.updateName = updateName;
	}

	/**
	 * 方法: 取得 java.lang.Integer
	 * 
	 * @return: java.lang.Integer 状态
	 */
	@Column(name = "enable_state", length = 5)
	public Integer getEnableState() {
		return enableState;
	}

	/**
	 * 方法: 设置java.lang.Integer
	 * 
	 * @param: java.lang.Integer
	 *             状态
	 */
	public void setEnableState(Integer enableState) {
		this.enableState = enableState;
	}

	/**
	 * 方法: 取得 java.lang.String
	 * 
	 * @return: java.lang.String  角色名称拼音简写
	 */
	@Column(name = "headstring", length = 50)
	public String getHeadString() {
		return headString;
	}

	/**
	 * 方法: 设置java.lang.String
	 * 
	 * @param: java.lang.String
	 *             角色名称拼音简写
	 */
	public void setHeadString(String headString) {
		this.headString = headString;
	}
}
