package com.biz.eisp.mdm.actrole.service;

import java.util.List;

import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.BaseService;
import com.biz.eisp.mdm.actrole.vo.TmActRoleVo;
import com.biz.eisp.mdm.position.vo.TmPositionVo;

/**
 * 工作流角色管理Service.
 * <p>
 * 
 * @author liukai
 * @version v1.0
 */
public interface TmActRoleService extends BaseService {

	/**
	 * 查询工作流角色，该角色下的职位的所属组织为当前组织的列表信息.
	 * <p>
	 * 筛选数据逻辑：<br>
	 * 1.查询工作流角色（=actRoleCode）下的职位 <br>
	 * 2.查询步骤1的职位信息的所属组织<br>
	 * 3.筛选出步骤2中的组织信息与当前组织ID（currOrgId）的组织信息<br>
	 * 4.查询出步骤3中的组织信息下的职位信息<br>
	 * 
	 * @param actRoleCode
	 *            工作流角色编码
	 * @param currOrgId
	 *            当前组织ID，系统操作者的组织ID
	 * @return
	 */
	public List<TmPositionVo> findCurrOrgPositionList(String actRoleCode, String currOrgId);

	/**
	 * 查询工作流角色，该角色下的职位的所属组织及其下级组织为当前组织的列表信息.
	 * <p>
	 * 筛选数据逻辑：<br>
	 * 1.查询工作流角色（=actRoleCode）下的职位<br>
	 * 2.查询步骤1的职位信息的所属组织，及其所属组织的下级组织<br>
	 * 3.筛选出步骤2中的组织信息与当前组织ID（currOrgId）的组织信息<br>
	 * 4.查询出步骤3中的组织信息下的职位信息<br>
	 * 
	 * @param actRoleCode
	 *            工作流角色编码
	 * @param currOrgId
	 *            当前组织ID，系统操作者的组织ID
	 * @return
	 */
	public List<TmPositionVo> findCurrAndSubOrgPositionList(String actRoleCode, String currOrgId);
	/**
	 * 查询当前组织及组织以下：
	 * 	逻辑：<br>
	 * 		1:查询工作流角色关系+工作流角色表+职位表
	 * 	    2:然后连接组织表，根据流程发起人的组织，找寻该组织下面所有的职位
	 * @param actRoleCode
	 * @param currOrgId
	 * @return
	 */
	public List<TmPositionVo> findCurrAndBelowOrgPositionList(String actRoleCode,String currOrgId);
	/**
	 * 查询工作流角色信息列表.
	 * <p>
	 * 
	 * @param tmActRoleVo
	 *            工作流角色Vo对象
	 * @param page
	 *            页面对象
	 * @return
	 */
	public List<TmActRoleVo> findActRoleList(TmActRoleVo tmActRoleVo, Page page);
	/**
	 * 获取工作流角色.
	 * @author grover
	 * @param tmActRoleVo 工作流角色vo对象
	 * @return  工作流角色集合
	 */
	List<TmActRoleVo> findActRoleMain(TmActRoleVo tmActRoleVo,Page page);
	/**
	 * 获取工作流角色.
	 * @author grover
	 * @param tmActRoleVo 工作流角色vo对象
	 * @return  工作流角色集合
	 */
	List<TmActRoleVo> findActRoleByPositionMain(TmActRoleVo tmActRoleVo,Page page);
	/**
	 * 得到全部的工作流角色，不分页
	 * @author wan
	 * @return
	 */
	List<TmActRoleVo> findAllRole();

	/**
	 * 找到负责改区域的审批人
	 * @param actRoleCode
	 * @param orgId
	 * @return
	 */
	public List<TmPositionVo> findResponsibleArea(String actRoleCode, String orgId);

	/**
	 * 按上级职位审批
	 * @param actRoleCode
	 * @param parent 
	 * @return
	 */
	public List<TmPositionVo> findParentPositionList(String actRoleCode, String parent);

	/**
	 * 找到所有上级
	 * @param actRoleCode
	 * @param submitPositionId
	 * @return
	 */
	public List<TmPositionVo> findParentsPositionList(String actRoleCode, String submitPositionId);
	
	/**
	 * 查询角色下所有的职位列表.
	 * <p>
	 * @param actRoleCode
	 * @return
	 */
	public List <TmPositionVo> findPositionList(String actRoleCode);
	
}
