package com.biz.eisp.mdm.actrole.service.impl;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.mdm.actrole.dao.TmActRoleDao;
import com.biz.eisp.mdm.actrole.entity.TmActRoleEntity;
import com.biz.eisp.mdm.actrole.service.TmActRoleService;
import com.biz.eisp.mdm.actrole.transformer.TmActRoleEntityToTmActRoleVo;
import com.biz.eisp.mdm.actrole.vo.TmActRoleVo;
import com.biz.eisp.mdm.position.vo.TmPositionVo;
import com.google.common.collect.Lists;

/**
 * 工作流角色管理Service 实现.
 * <p>
 * 
 * @author liukai
 * @version v1.0
 */
@Service("tmActRoleService")
@Transactional
public class TmActRoleServiceImpl extends BaseServiceImpl implements TmActRoleService {

	@Autowired
	private TmActRoleDao tmActRoleDao;

	@Override
	public List<TmPositionVo> findCurrOrgPositionList(String actRoleCode, String currOrgId) {
		List<TmPositionVo> voList = tmActRoleDao.findCurrOrgPositionList(actRoleCode, currOrgId);
		return voList;
	}

	@Override
	public List<TmPositionVo> findCurrAndSubOrgPositionList(String actRoleCode, String currOrgId) {
		List<TmPositionVo> voList = tmActRoleDao.findCurrAndSubOrgPositionList(actRoleCode, currOrgId);
		return voList;
	}

	@Override
	public List<TmPositionVo> findCurrAndBelowOrgPositionList(String actRoleCode, String currOrgId) {
		return tmActRoleDao.findCurrAndBelowOrgPositionList(actRoleCode,currOrgId);
	}
	
	@Override
	public List<TmActRoleVo> findActRoleList(TmActRoleVo tmActRoleVo, Page page) {
		String hql = "from TmActRoleEntity t where 1=1 ";
		
		List <String> params = new ArrayList<String>();
		
		if(StringUtils.isNotBlank(tmActRoleVo.getRoleCode())) {
			hql += " and t.roleCode like ?";
			params.add("%" + tmActRoleVo.getRoleCode() + "%");
		}
		if(StringUtils.isNotBlank(tmActRoleVo.getRoleName())) {
			hql += " and t.roleName like ?";
			params.add("%" + tmActRoleVo.getRoleName() + "%");
		}
		
		List<TmActRoleEntity> entityList = this.findByHql(hql, page, params.toArray());
		List<TmActRoleVo> voList = Lists.transform(entityList, new TmActRoleEntityToTmActRoleVo());
		return voList;
	}

	@Override
	public List<TmActRoleVo> findActRoleMain(TmActRoleVo tmActRoleVo,Page page) {
		List<TmActRoleVo> list = tmActRoleDao.findActRoleByConditions(tmActRoleVo, page);
		return list;
	}

	@Override
	public List<TmActRoleVo> findAllRole() {
		String hql = "from TmActRoleEntity";
		List<TmActRoleEntity> entityList = this.findByHql(hql);
		List<TmActRoleVo> voList = Lists.transform(entityList, new TmActRoleEntityToTmActRoleVo());
		return voList;
	}

	@Override
	public List<TmActRoleVo> findActRoleByPositionMain(TmActRoleVo tmActRoleVo,
			Page page) {
		return tmActRoleDao.findActRoleByPosition(tmActRoleVo, page);
	}

	@Override
	public List<TmPositionVo> findResponsibleArea(String actRoleCode, String currOrgId) {
		List<TmPositionVo> voList = tmActRoleDao.findResponsibleArea(actRoleCode, currOrgId);
		return voList;
	}

	@Override
	public List<TmPositionVo> findParentPositionList(String actRoleCode, String parent) {
		List<TmPositionVo> voList = tmActRoleDao.findParentPositionList(actRoleCode, parent);
		return voList;
	}

	@Override
	public List<TmPositionVo> findParentsPositionList(String actRoleCode, String submitPositionId) {
		List<TmPositionVo> voList = tmActRoleDao.findParentsPositionList(actRoleCode, submitPositionId);
		return voList;
	}

	@Override
	public List<TmPositionVo> findPositionList(String actRoleCode) {
		List<TmPositionVo> voList = tmActRoleDao.findPositionList(actRoleCode);
		return voList;
	}
}
