package com.biz.eisp.mdm.actrole.vo;

import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.importer.ImpEventHandler;
import com.biz.eisp.base.importer.validator.ValidateException;
import com.biz.eisp.base.utils.ApplicationContextUtils;
import com.biz.eisp.mdm.actrole.entity.TmActRoleEntity;
import com.biz.eisp.mdm.actrole.entity.TmRPositionActRoleEntity;
import com.biz.eisp.mdm.actrole.service.TmActRoleService;
import com.biz.eisp.mdm.position.entity.TmPositionEntity;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * Created by liukai on 2017/11/1.
 * 工作流角色职位关系导入处理器
 */
public class TmActRolePositionRelHandler extends ImpEventHandler<TmActRolePositionRelImportVo> {

    /**
     * 要导入的关系数据
     */
    private List<TmRPositionActRoleEntity> importDataList = new ArrayList<TmRPositionActRoleEntity>();
    private TmActRoleService tmActRoleService;
    private int succNum = 0;
    private int errNum = 0;
    private StringBuilder errors = new StringBuilder();

    public TmActRolePositionRelHandler() {
        tmActRoleService = ApplicationContextUtils.getContext().getBean(TmActRoleService.class);
    }

    @Override
    public void endRow(Map<String, Object> row, TmActRolePositionRelImportVo bean) throws ValidateException {
        String positionCode = bean.getPositionCode();
        String actRoleCode = bean.getActRoleCode();

        TmPositionEntity positionEntity = tmActRoleService
                .findUniqueByProperty(TmPositionEntity.class, "positionCode", positionCode);
        TmActRoleEntity actRoleEntity = tmActRoleService
                .findUniqueByProperty(TmActRoleEntity.class, "roleCode", actRoleCode);

        if(positionEntity == null) {
            this.addErrorMsg("职位编码：" + positionCode + "不存在");
        }

        if(actRoleEntity == null) {
            this.addErrorMsg("角色编码：" + actRoleCode + "不存在");
        }

        if(positionEntity != null && actRoleEntity != null) {
            TmRPositionActRoleEntity entity = getExistTmRPositionActRoleEntity(positionEntity.getId(),
                    actRoleEntity.getId());
            if(entity == null) {
                //不存在则新增
                entity = new TmRPositionActRoleEntity();
            }
            //把数据添加到保存数据列表中
            entity.setTmPosition(positionEntity);
            entity.setTmActRole(actRoleEntity);

            importDataList.add(entity);

            //设置导入成功信息
            succNum++;
            this.setSuccNum(succNum);
        }

    }

    /**
     * 是否存在职位-工作流角色的对应关系数据
     * @param positionId
     * @param actRoleId
     * @return
     */
    private TmRPositionActRoleEntity getExistTmRPositionActRoleEntity(String positionId, String actRoleId) {
        String hql = "from TmRPositionActRoleEntity where tmPosition.id = ? and tmActRole.id = ?";
        List<TmRPositionActRoleEntity> tmRPositionActRoleEntityList = tmActRoleService.findByHql(hql,positionId,actRoleId);
        if(CollectionUtil.listNotEmptyNotSizeZero(tmRPositionActRoleEntityList)){
            return tmRPositionActRoleEntityList.get(0);
        }
        return null;
    }

    /**
     * 添加错误信息提示
     * @param error
     * @throws ValidateException
     */
    private void addErrorMsg(String error) throws ValidateException {
        this.errors.append("【第" +this.getRowNumber()+"行】:" + error).append("<br/>");
        this.errNum += 1;
        if (this.errNum > 200)
            throw new ValidateException(this.errors.toString());
    }

    public void end(){
        if(errNum > 0) {
            //返回导入验证失败的数据
            throw new BusinessException(this.errors.toString());
        }

        //保存导入数据
        this.saveData();
        //导入是分批次提交，end()方法会多次调用，保存完了把数据清掉，不然会重复保存
        importDataList.clear();
    }

    /**
     * 保存导入数据到数据库
     */
    private void saveData() {
        if(CollectionUtil.listNotEmptyNotSizeZero(importDataList)) {
            for(TmRPositionActRoleEntity entity : importDataList) {
                tmActRoleService.saveOrUpdate(entity);
            }
        }
    }

}
