package com.biz.eisp.mdm.administrativearea.controller;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.ComboBox;
import com.biz.eisp.base.common.jsonmodel.ValidForm;
import com.biz.eisp.base.common.util.OConvertUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.EuPage;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.web.BaseController;
import com.biz.eisp.mdm.administrativearea.service.TmAdministrativeAreaService;
import com.biz.eisp.mdm.administrativearea.vo.TmAdministrativeAreaExcelVo;
import com.biz.eisp.mdm.administrativearea.vo.TmAdministrativeAreaVo;

/**
 * 业务区域Controller.
 * <p>
 * @author liukai
 * @version v1.0
 */
@Controller
@RequestMapping("/tmAdministrativeAreaController")
public class TmAdministrativeAreaController extends BaseController{
	
	@Autowired
	TmAdministrativeAreaService tmAdministrativeAreaService;//注入业务区域Service
	
	/**
	 * 跳转业务区域页面.
	 * @author wan
	 * @param request 请求对象
	 * @return 业务区域主界面
	 */
	@RequestMapping(value= "goTmAdministrativeAreaMain",method = {RequestMethod.GET,RequestMethod.POST})
	public ModelAndView goTmAdministrativeAreaMain(HttpServletRequest request) {
		//动态表单参数 表名
		request.setAttribute("extendTableName",Globals.TABLE_ADMINISTRATIVE_AREA);
		return new ModelAndView("com/biz/eisp/mdm/administrativeArea/tmAdministrativeAreaMain");
	}
	
	/**
	 * 跳转业务区域选择页面.
	 * @author wan
	 * @param request 请求对象
	 * @return 产品选择界面
	 */
	@RequestMapping(value = "goTmAdministrativeAreaSelectMain",method = {RequestMethod.GET,RequestMethod.POST})
	public ModelAndView goTmProductSelectMain(HttpServletRequest request) {
		return new ModelAndView("com/biz/eisp/mdm/administrativeArea/tmAdministrativeAreaSelectMain");
	}
	
	/**
	 * 查询区域数据列表.
	 * <p>
	 * 如果只有id，没有查询条件，即动态加载该id的子节点。
	 * 如果有查询条件，即进行查询操作。返回所有的值，构造children结构
	 * @param tmAdministrativeAreaVo
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "findTmAdministrativeAreaList", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public List <TmAdministrativeAreaVo> findTmAdministrativeAreaList(TmAdministrativeAreaVo tmAdministrativeAreaVo, HttpServletRequest request) {
		List <TmAdministrativeAreaVo> voList = tmAdministrativeAreaService.findAdministrativeAreaList(tmAdministrativeAreaVo);
		return voList;
	}
	
	/**
	 * 查询区域数据列表ComboTree形式.
	 * @param tmAdministrativeAreaVo
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "findTmAdministrativeAreaComboTree",method = {RequestMethod.GET,RequestMethod.POST})
	@ResponseBody
	public List <TmAdministrativeAreaVo> findTmAdministrativeAreaComboTree(TmAdministrativeAreaVo tmAdministrativeAreaVo, HttpServletRequest request) {
		List <TmAdministrativeAreaVo> voList = tmAdministrativeAreaService.findTmAdministrativeAreaComboTree(tmAdministrativeAreaVo, request.getParameter("selfId"));
		return voList;
	}
	
	/**
	 * 业务区域Form表单页面..
	 * <p>
	 * @param request
	 * @param tmAdministrativeAreaVo
	 * @return
	 */
	@RequestMapping(value = "goTmAdministrativeAreaForm", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goTmAdministrativeAreaForm(HttpServletRequest request, TmAdministrativeAreaVo tmAdministrativeAreaVo) {
		//动态表单参数 表名
		request.setAttribute("extendTableName", Globals.TABLE_ADMINISTRATIVE_AREA);
		//表单类型0新增1编辑2查看
		String optype = request.getParameter("optype");
		request.setAttribute("optype", optype);
		
		if(StringUtil.isNotEmpty(tmAdministrativeAreaVo.getId())){
			TmAdministrativeAreaVo vo = tmAdministrativeAreaService.getTmAdministrativeAreaVo(tmAdministrativeAreaVo.getId());
			request.setAttribute("tba", vo);
		}
		
		return new ModelAndView("com/biz/eisp/mdm/administrativeArea/tmAdministrativeAreaForm");
	}
	
	/**
	 * 获取业务区域省市区联动.
	 * <p>获取上级业务区域的方法
	 * @author Sean
	 * @param request 请求对象
	 * @param tba 业务区域vo对象
	 * @return 列表 数据 
	 */
	@RequestMapping(value = "getAreaForCombobox",method = {RequestMethod.GET,RequestMethod.POST})
	@ResponseBody
	public List<ComboBox> getAreaForCombobox(HttpServletRequest request,TmAdministrativeAreaExcelVo tba) {
		try {
			String name=request.getParameter("name");
			if(StringUtil.isNotEmpty(name)){
				name = URLDecoder.decode(name, "UTF-8"); 
				tba.setAdministrativeAreaName(name);
			}
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
		}
		return tmAdministrativeAreaService.findAdministrativeAreaCombobox(tba);
	}
	
	/**
	 * 保存编辑.
	 * @param orgVo 业务区域vo对象
	 * @return 成功或者失败
	 */
	@RequestMapping(value = "saveTmAdministrativeArea", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson saveTmAdministrativeArea(HttpServletRequest request, TmAdministrativeAreaVo tmAdministrativeAreaVo) {
		AjaxJson j = new AjaxJson();
		try {
			Page page = new EuPage(request);
			//保存数据
			tmAdministrativeAreaService.saveTmAdministrativeArea(tmAdministrativeAreaVo, page);
			//更新叶子节点状态
			tmAdministrativeAreaService.updateIsLeafColumn("tm_administrative_area");
			
			//设置编码和名称，用于保存后进行查询操作
			Map <String, Object>attributes = new HashMap<String, Object>();
			attributes.put("administrativeAreaCode", tmAdministrativeAreaVo.getAdministrativeAreaCode());
			attributes.put("text", tmAdministrativeAreaVo.getAdministrativeAreaName());
			j.setAttributes(attributes);
		} catch (Exception e) {
			j.setSuccess(false);
			j.setMsg("操作失败:" + e.getMessage());
			e.printStackTrace();
		}
		return j;
	}
	
	/**
	 * 删除业务区域.
	 * @author wan
	 * @param ids 业务区域ids
	 * @return 成功或者失败
	 */
	@RequestMapping(value = "deleteTmAdministrativeArea", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson deleteTmAdministrativeArea(String id) {
		try {
			//删除业务区域
			tmAdministrativeAreaService.deleteTmAdministrativeArea(id);
			//更新叶子节点状态
			tmAdministrativeAreaService.updateIsLeafColumn("tm_administrative_area");
		} catch(Exception e) {
			return new AjaxJson("删除失败:" + e.getMessage());
		}
		return new AjaxJson();
	}
	
	/**
	 * 验证重复name.
	 * @author wan
	 * @param 验证对象
	 * @param tba 业务区域vo对象
	 */
	@RequestMapping(value = "validateAdministrativeAreaName",method = {RequestMethod.GET,RequestMethod.POST})
	@ResponseBody
	public ValidForm validateAdministrativeAreaName(HttpServletRequest request,TmAdministrativeAreaExcelVo tba) {
		String param = OConvertUtils.getString(request.getParameter("param"));
		ValidForm validForm = new ValidForm();
		//验证
		//取消验证
//		if(StringUtil.isNotEmpty(tba.getId())){
//			//修改
//			if(tmAdministrativeAreaService.validate(tba.getId(), param, "administrativeAreaName")){
//				validForm.setStatus("n");
//				validForm.setInfo("业务区域名称已存在");
//			}
//		}else{
//			//新增
//			if(tmAdministrativeAreaService.validate(null, param, "administrativeAreaName")){
//				validForm.setStatus("n");
//				validForm.setInfo("业务区域名称已存在");
//			}
//		}
		return validForm;
	}
	/**
	 * 验证重复Code.
	 * @author wuzhujun
	 * @param request
	 * @param tba
	 * @return
	 */
	@RequestMapping(value = "validateAdministrativeAreaCode",method = {RequestMethod.GET,RequestMethod.POST})
	@ResponseBody
	public ValidForm validateAdministrativeAreaCode(HttpServletRequest request,TmAdministrativeAreaExcelVo tba) {
		String param = OConvertUtils.getString(request.getParameter("param"));
		ValidForm validForm = new ValidForm();
		//验证
		if(StringUtil.isNotEmpty(tba.getId())){
			//修改
			if(tmAdministrativeAreaService.validate(tba.getId(), param, "administrativeAreaCode")){
				validForm.setStatus("n");
				validForm.setInfo("业务区域编码已存在");
			}
		}else{
			if(tmAdministrativeAreaService.validate(null, param, "administrativeAreaCode")){
				validForm.setStatus("n");
				validForm.setInfo("业务区域编码已存在");
			}
		}
		return validForm;
	}
	
	/**
	 * 启用数据.
	 * <p>
	 * @param tmAdministrativeAreaVo
	 * @return
	 */
	@RequestMapping(value = "startTmAdministrativeArea", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson startTmAdministrativeArea(TmAdministrativeAreaVo tmAdministrativeAreaVo){
		try {
			tmAdministrativeAreaVo.setEnableStatus(0);
			tmAdministrativeAreaService.updateAdministrativeAreaEnableStatus(tmAdministrativeAreaVo);
			return new AjaxJson();
		} catch(Exception e) {
			e.printStackTrace();
			return new AjaxJson(e.getMessage());
		}
	}
	
	/**
	 * 停用数据.
	 * <p>
	 * @param tmAdministrativeAreaVo
	 * @return
	 */
	@RequestMapping(value = "stopTmAdministrativeArea", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson stopTmAdministrativeArea(TmAdministrativeAreaVo tmAdministrativeAreaVo){
		try {
			tmAdministrativeAreaVo.setEnableStatus(1);
			tmAdministrativeAreaService.updateAdministrativeAreaEnableStatus(tmAdministrativeAreaVo);
			return new AjaxJson();
		} catch(Exception e) {
			e.printStackTrace();
			return new AjaxJson(e.getMessage());
		}
		
	}
	
	/**
	 * 行政区域列表excel导出
	 * @author wuzhujun
	 * @param custOrgVo 客户组织关系vo
	 * @param request 请求对象
	 * @param response 响应对象
	 */
	@RequestMapping(value = "exportXls", method = {RequestMethod.GET, RequestMethod.POST})
	public void exportXls(TmAdministrativeAreaVo tmAdministrativeAreaVo, HttpServletRequest request, HttpServletResponse response) {
		tmAdministrativeAreaVo.setExportExcel("true"); //设置为导出状态
		List<TmAdministrativeAreaVo> tmAdministrativeAreaVoList = tmAdministrativeAreaService.findAdministrativeAreaList(tmAdministrativeAreaVo);
		doExportXls(response, request, tmAdministrativeAreaVoList, TmAdministrativeAreaVo.class, "行政区域列表");
	}
}
