package com.biz.eisp.mdm.administrativearea.dao;

import java.util.List;

import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.interfacedao.annotation.Arguments;
import com.biz.eisp.base.interfacedao.annotation.InterfaceDao;
import com.biz.eisp.base.interfacedao.annotation.ResultType;
import com.biz.eisp.mdm.administrativearea.entity.TmAdministrativeAreaEntity;
import com.biz.eisp.mdm.administrativearea.vo.TmAdministrativeAreaExcelVo;
import com.biz.eisp.mdm.administrativearea.vo.TmAdministrativeAreaVo;

@InterfaceDao
public interface TmAdministrativeAreaDao {
	
	@Arguments({"tbaVo","page"})
	@ResultType(TmAdministrativeAreaExcelVo.class)
	public List <TmAdministrativeAreaExcelVo> findTmAdministrativeAreaList(TmAdministrativeAreaExcelVo tbaVo, Page page);
	
	@Arguments({"tmAdministrativeAreaVo","fields","conditions"})
	@ResultType(TmAdministrativeAreaVo.class)  
	public List<TmAdministrativeAreaVo> findNodeAdministrativeAreaList(TmAdministrativeAreaVo tmAdministrativeAreaVo, String fields, String conditions);
	
	@Arguments({"tmAdministrativeAreaVo","fields","conditions"})
	@ResultType(TmAdministrativeAreaVo.class)  
	public List<TmAdministrativeAreaVo> findQueryAdministrativeAreaList(TmAdministrativeAreaVo tmAdministrativeAreaVo, String fields, String conditions);

	public void updateLeafNode(); 
	
	public void updateNotLeafNode();
	
	@ResultType(TmAdministrativeAreaEntity.class)
	@Arguments({"vo"})
	public List<TmAdministrativeAreaEntity> findChildrenAdministrativeAreaList(TmAdministrativeAreaVo vo);
	
	@ResultType(TmAdministrativeAreaVo.class)
	@Arguments({"conditions"})
	public List<TmAdministrativeAreaVo> findTmAdministrativeAreaListByConditions(String conditions);
}
