package com.biz.eisp.mdm.administrativearea.service;

import java.util.List;

import com.biz.eisp.base.common.jsonmodel.ComboBox;
import com.biz.eisp.base.common.jsonmodel.ComboTree;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.BaseService;
import com.biz.eisp.mdm.administrativearea.vo.TmAdministrativeAreaExcelVo;
import com.biz.eisp.mdm.administrativearea.vo.TmAdministrativeAreaVo;

/**
 * 业务区域 服务层接口.
 * 
 * @author wan
 * @version v1.0
 */
public interface TmAdministrativeAreaService extends BaseService {

	/**
	 * 保存业务区域.
	 * <p>
	 * 保存业务区域接口的定义
	 * 
	 * @author wan
	 * @param tba
	 *            组织vo对象
	 * @param page 
	 * 			  页面对象
	 */
	void saveTmAdministrativeArea(TmAdministrativeAreaVo tmAdministrativeAreaVo, Page page);

	/**
	 * 删除业务区域.
	 * 
	 * @author wan
	 * @param id
	 *            业务区域id
	 */
	void deleteTmAdministrativeArea(String id);

	/**
	 * 更新启动或者停用状态
	 * 
	 * @author wan
	 * @param tbaVo
	 * @return
	 */
	void updateAdministrativeAreaEnableStatus(TmAdministrativeAreaVo tmAdministrativeAreaVo);

	/**
	 * 获取下拉列表
	 * 
	 * @param tba
	 * @return
	 */
	public List<ComboBox> findAdministrativeAreaCombobox(TmAdministrativeAreaExcelVo tba);

	/**
	 * 验证重复的字段
	 * 
	 * @author wuzhujun
	 * @param fields
	 *            字段-值
	 * @return 重复为true 否则为flase
	 */
	public boolean validate(String id, String param, String fieldName);

	/**
	 * 获取区域Vo对象.
	 * <p>
	 * 
	 * @param id
	 *            区域id
	 * @return
	 */
	public TmAdministrativeAreaVo getTmAdministrativeAreaVo(String id);

	/**
	 * 查询区域数据列表.
	 * <p>
	 * 如果只有id，没有查询条件，即动态加载该id的子节点。
	 * 如果有查询条件，即进行查询操作。返回所有的值，构造children结构
	 * @param tmAdministrativeAreaVo
	 * @return
	 */
	List<TmAdministrativeAreaVo> findAdministrativeAreaList(TmAdministrativeAreaVo tmAdministrativeAreaVo);

	/**
	 * 查询区域数据列表 ComboTree形式，取数方式参照findAdministrativeAreaList
	 * @param tmAdministrativeAreaVo
	 * @param selfId
	 * @return
	 */
	List <TmAdministrativeAreaVo> findTmAdministrativeAreaComboTree(TmAdministrativeAreaVo tmAdministrativeAreaVo, String selfId);
	
	/**
	 * 更新叶子节点状态.
	 * <p>
	 */
	void updateTmAdministrativeAreaIsLeaf();
	
	/**
	 * 根据区域id，查询该区域下面所有区域
	 * @author wan
	 * @param vo
	 * @return
	 */
	List<ComboTree> findChildrenAdministrativeArea(TmAdministrativeAreaVo vo);
	
	/**
	 * 根据传入的条件，直接查询
	 * <p>如：(in ('121','343','t454')
	 * @author wan
	 * @param conditions
	 * @return
	 */
	List<TmAdministrativeAreaVo> findAdministrativeAreaLists(String conditions);
}
