package com.biz.eisp.mdm.administrativearea.service.impl;

import java.util.Map;

import com.biz.eisp.base.core.page.EuPage;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.importer.ImpEventHandler;
import com.biz.eisp.base.importer.validator.ValidateException;
import com.biz.eisp.base.utils.ApplicationContextUtils;
import com.biz.eisp.mdm.administrativearea.service.TmAdministrativeAreaService;
import com.biz.eisp.mdm.administrativearea.vo.TmAdministrativeAreaVo;

/**
 * 行政区域信息excel导入 
 * @author 肖胜
 * @version v1.0
 */
public class TmAdministrativeAreaEventHandler extends ImpEventHandler <TmAdministrativeAreaVo>{
	
	// 行政区域service注入
	private TmAdministrativeAreaService tmAdministrativeAreaService = (TmAdministrativeAreaService) 
			ApplicationContextUtils.getContext().getBean("tmAdministrativeAreaService");
	
	
	@Override
	public void endRow(Map<String, Object> row, TmAdministrativeAreaVo bean) throws ValidateException {
		try {
			Page page = new EuPage();
			tmAdministrativeAreaService.saveTmAdministrativeArea(bean, page);	//执行保存
		} catch (Exception e) {
			addError("第"+getRowNumber()+"行遇到错误:"+e.getMessage());
			e.printStackTrace();
		}
		//设置已成功导入条数
		setSuccNum(getSuccNum()+1);
	}

	public void end() {
		//保存完毕后 更新叶子节点状态. 
		tmAdministrativeAreaService.updateTmAdministrativeAreaIsLeaf();
	}
	
}
