package com.biz.eisp.mdm.administrativearea.service.impl;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.ComboBox;
import com.biz.eisp.base.common.jsonmodel.ComboTree;
import com.biz.eisp.base.common.tag.bean.ComboTreeModel;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.common.util.TreeGridUtil;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.mdm.administrativearea.dao.TmAdministrativeAreaDao;
import com.biz.eisp.mdm.administrativearea.entity.TmAdministrativeAreaEntity;
import com.biz.eisp.mdm.administrativearea.service.TmAdministrativeAreaExtendService;
import com.biz.eisp.mdm.administrativearea.service.TmAdministrativeAreaService;
import com.biz.eisp.mdm.administrativearea.transformer.TmAdministrativeAreaEntityToTmAdministrativeAreaVo;
import com.biz.eisp.mdm.administrativearea.transformer.TmAdministrativeAreaVoToTmAdministrativeAreaEntity;
import com.biz.eisp.mdm.administrativearea.vo.TmAdministrativeAreaExcelVo;
import com.biz.eisp.mdm.administrativearea.vo.TmAdministrativeAreaVo;
import com.biz.eisp.mdm.config.util.DynamicConfigUtil;
import com.google.common.collect.Lists;

/** 业务区域 服务层实现.
 * <p>
 * @author wan
 * @version v1.0
 */
@Service("tmAdministrativeAreaService")
@Transactional
public class TmAdministrativeAreaServiceImpl extends BaseServiceImpl implements TmAdministrativeAreaService{
	/**
	 * 注入Dao接口.
	 */
	@Autowired
	private TmAdministrativeAreaDao tmAdministrativeAreaDao; 
	/**
	 * 注入扩展service
	 */
	@Autowired(required=false)
	private TmAdministrativeAreaExtendService tmAdministrativeAreaExtendService;
	
	@Override
	public void saveTmAdministrativeArea(TmAdministrativeAreaVo tmAdministrativeAreaVo, Page page) {
		TmAdministrativeAreaEntity tmAdministrativeAreaEntity =null;
		//保存前扩展 此时entity还未通过vo转换
		if(StringUtil.isNotEmpty(tmAdministrativeAreaExtendService)){
			//验证
			try {
				tmAdministrativeAreaExtendService.validate(tmAdministrativeAreaVo, page);
			} catch (Exception e) {
				throw new BusinessException("验证数据失败:"+e.getMessage());
			}
			//扩展
			tmAdministrativeAreaEntity = tmAdministrativeAreaExtendService.saveBefore(tmAdministrativeAreaVo, page);
		}
		//如果entity为null 则通过vo转换
		if(StringUtil.isEmpty(tmAdministrativeAreaEntity)){
			tmAdministrativeAreaEntity = new TmAdministrativeAreaVoToTmAdministrativeAreaEntity(this).apply(tmAdministrativeAreaVo);
		}
		//保存前扩展 此时entity已经通过vo转换
		if(StringUtil.isNotEmpty(tmAdministrativeAreaExtendService)){
			tmAdministrativeAreaEntity = tmAdministrativeAreaExtendService.saveBefore(tmAdministrativeAreaEntity, tmAdministrativeAreaVo, page);
		}
		//保存
		saveOrUpdate(tmAdministrativeAreaEntity);
		//保存后扩展
		if(StringUtil.isNotEmpty(tmAdministrativeAreaExtendService)){
			tmAdministrativeAreaEntity = tmAdministrativeAreaExtendService.savePost(tmAdministrativeAreaEntity, tmAdministrativeAreaVo, page);
		}
	}
	
	@Override
	public void deleteTmAdministrativeArea(String id) {
		TmAdministrativeAreaEntity tbaEntity = get(TmAdministrativeAreaEntity.class, id);
		if(tbaEntity.getIsLeaf() == 0) {
			throw new BusinessException("存在子节点不能删除");
		}
		delete(tbaEntity);
	}
	
	@Override
	public void updateAdministrativeAreaEnableStatus(TmAdministrativeAreaVo tmAdministrativeAreaVo) {
		TmAdministrativeAreaEntity entity = get(TmAdministrativeAreaEntity.class, tmAdministrativeAreaVo.getId());		
		entity.setEnableStatus(tmAdministrativeAreaVo.getEnableStatus());
		updateEntity(entity);
	}
	
	@Override
	public List<ComboBox> findAdministrativeAreaCombobox(TmAdministrativeAreaExcelVo tba) {
		String sql="select distinct  t.name text,t.name value  from tm_administrative_area t "
				+ "left join  tm_administrative_area t1 on t1.id=t.PARENT_ID where 1=1";
		List<ComboBox> comList=null;
		
		if(StringUtil.isNotEmpty(tba.getAreaLevel())){
			sql+=" and t.AREA_LEVEL=?";
			comList= this.findBySql(ComboBox.class,sql, tba.getAreaLevel());
		}
		if(StringUtil.isNotEmpty(tba.getAdministrativeAreaName())){
			sql+=" and t1.name=?";
			comList= this.findBySql(ComboBox.class,sql, tba.getAdministrativeAreaName());
		}
	
		return comList;
	}
	
	@Override
	public boolean validate(String id,String param,String fieldName) {
		
		Criterion cr1 = Restrictions.eq(fieldName, param);
		List<TmAdministrativeAreaEntity> tmtbas = new ArrayList<TmAdministrativeAreaEntity>();
		if(StringUtil.isNotEmpty(id)){
			Criterion cr2 = Restrictions.ne("id", id);
			tmtbas = findByCriteria(TmAdministrativeAreaEntity.class, cr1, cr2);
		}else{
			tmtbas = findByCriteria(TmAdministrativeAreaEntity.class, cr1);
		}
		if(!CollectionUtils.isEmpty(tmtbas)){
			return true;
		}
		return false;
	}
	
	@Override
	public List<TmAdministrativeAreaVo> findAdministrativeAreaList(TmAdministrativeAreaVo tmAdministrativeAreaVo) {
		//动态sql
		String sql = DynamicConfigUtil.getInstance().buildTreeGridQuerySql(Globals.TABLE_ADMINISTRATIVE_AREA, tmAdministrativeAreaVo);
		List <TmAdministrativeAreaVo> voList = findBySql(TmAdministrativeAreaVo.class, sql);
		//如果有查询条件 则组装树形
		if(DynamicConfigUtil.getInstance().isHaveQuery(Globals.TABLE_ADMINISTRATIVE_AREA, tmAdministrativeAreaVo)) {
			voList = this.findQueryAdministrativeAreaList(tmAdministrativeAreaVo, voList);
		}
		return voList;
	}
	
	@Override
	public List <TmAdministrativeAreaVo> findTmAdministrativeAreaComboTree(TmAdministrativeAreaVo tmAdministrativeAreaVo, String selfId) {
		List <TmAdministrativeAreaVo> voList = null;
		if(StringUtils.isNotBlank(selfId)) {
			List <TmAdministrativeAreaEntity> entityList = this.findByProperty(TmAdministrativeAreaEntity.class, "id", selfId);
			voList = Lists.transform(entityList, new TmAdministrativeAreaEntityToTmAdministrativeAreaVo()); 
		} else {
			voList = this.findAdministrativeAreaList(tmAdministrativeAreaVo);
		}
		return voList;
	}
	
	/**
	 * 拥有查询条件的方式，查询出整棵树的数据出来.
	 * <p>
	 * @param tmAdministrativeAreaVo 区域Vo对象， 主要传递查询条件值
	 * @param fields
	 * @param conditions
	 * @return
	 */
	private List <TmAdministrativeAreaVo> findQueryAdministrativeAreaList(TmAdministrativeAreaVo tmAdministrativeAreaVo, List <TmAdministrativeAreaVo> voList) {
		//如果是导出，即不用组装成TreeGrid 带有children的树形截至值，直接返回列表值
		if(tmAdministrativeAreaVo.getExportExcel().equals("true")) {
			return voList;
		}
		//构造成树状值传回
		List <TmAdministrativeAreaVo> allQueryVoList = TreeGridUtil.buildTreeGrid(voList);
		return allQueryVoList;
	}
	
	@Override
	public void updateTmAdministrativeAreaIsLeaf() {
		tmAdministrativeAreaDao.updateLeafNode();
		tmAdministrativeAreaDao.updateNotLeafNode();
	}
	
	@Override
	public TmAdministrativeAreaVo getTmAdministrativeAreaVo(String id) {
		TmAdministrativeAreaEntity entity = this.get(TmAdministrativeAreaEntity.class, id);
		TmAdministrativeAreaVo vo = new TmAdministrativeAreaEntityToTmAdministrativeAreaVo().apply(entity);
		return vo;
	}

	@Override
	public List<ComboTree> findChildrenAdministrativeArea(TmAdministrativeAreaVo vo) {
		if(StringUtils.isNotBlank(vo.getId())){
			List<TmAdministrativeAreaEntity> list = tmAdministrativeAreaDao.findChildrenAdministrativeAreaList(vo);
			for(TmAdministrativeAreaEntity entity : list){
				String id = entity.getId();
				String sql = "select * from tm_administrative_area t where t.parent_id = ?";
				List<TmAdministrativeAreaEntity> lists = findBySql(TmAdministrativeAreaEntity.class, sql, id);
				entity.setTmAdministrativeAreas(lists);
			}
			ComboTreeModel comboTreeModel = new ComboTreeModel("id", "administrativeAreaName", "tmAdministrativeAreas");
			List<ComboTree> comboTrees = this.comboTree(list, comboTreeModel, null, false);
			return comboTrees;
		}else{
			return null;
		}
	}

	@Override
	public List<TmAdministrativeAreaVo> findAdministrativeAreaLists(String conditions) {
		List<TmAdministrativeAreaVo> list = null;
		if(StringUtils.isNotBlank(conditions)){
			list = tmAdministrativeAreaDao.findTmAdministrativeAreaListByConditions(conditions);
		}
		return list;
	}
}
