package com.biz.eisp.mdm.administrativearea.transformer;

import org.springframework.beans.BeanUtils;

import com.biz.eisp.mdm.administrativearea.entity.TmAdministrativeAreaEntity;
import com.biz.eisp.mdm.administrativearea.vo.TmAdministrativeAreaVo;
import com.google.common.base.Function;

/**
 * TmAdministrativeAreaEntity 转换 TmAdministrativeAreaVo.
 * <p>
 * 
 * @author liukai
 * @version v1.0
 */
public class TmAdministrativeAreaEntityToTmAdministrativeAreaVo implements Function<TmAdministrativeAreaEntity, TmAdministrativeAreaVo> {

	@Override
	public TmAdministrativeAreaVo apply(TmAdministrativeAreaEntity entity) {
		if(entity == null) {
			return null;
		}
		TmAdministrativeAreaVo vo = new TmAdministrativeAreaVo();
		BeanUtils.copyProperties(entity, vo);
		
		TmAdministrativeAreaEntity parentEntity = entity.getTmAdministrativeArea();
		if(parentEntity != null) {
			vo.setParentId(parentEntity.getId());
			vo.setParentName(parentEntity.getAdministrativeAreaName());
			vo.setParentCode(parentEntity.getAdministrativeAreaCode());
		}
		vo.setText(entity.getAdministrativeAreaName());
		
		return vo;
	}

}
