package com.biz.eisp.mdm.administrativearea.transformer;


import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.MyBeanUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.utils.ApplicationContextUtils;
import com.biz.eisp.mdm.administrativearea.entity.TmAdministrativeAreaEntity;
import com.biz.eisp.mdm.administrativearea.service.TmAdministrativeAreaService;
import com.biz.eisp.mdm.administrativearea.vo.TmAdministrativeAreaExcelVo;
import com.google.common.base.Function;

/** 
 * vo→po
 * @author wan
 * @version v1.0
 */
public class TmAdministrativeAreaTransFormPo implements Function<TmAdministrativeAreaExcelVo, TmAdministrativeAreaEntity>{
	/**
	 * 注入service
	 */
	private TmAdministrativeAreaService tmAdministrativeAreaService = (TmAdministrativeAreaService) ApplicationContextUtils.getContext().getBean("tmAdministrativeAreaService");
	@Override
	public TmAdministrativeAreaEntity apply(TmAdministrativeAreaExcelVo t) {
		TmAdministrativeAreaEntity tmAdministrativeAreaEntity = null;
		//判断是新增还是修改
		if(StringUtil.isNotEmpty(t.getId())){
			tmAdministrativeAreaEntity = tmAdministrativeAreaService.get(TmAdministrativeAreaEntity.class, t.getId());
			if(StringUtil.isNotEmpty(t.getAdministrativeAreaName())){
				if(tmAdministrativeAreaService.validate(t.getId(),t.getAdministrativeAreaName() , "name")){
					throw new BusinessException("转换行政区域关系Vo到Po时，行政区域"+ t.getAdministrativeAreaName()+"已存在" );
				}
			}else{
				throw new BusinessException("行政区域名称不能为空" );
			}
			if(StringUtil.isNotEmpty(t.getAdministrativeAreaCode())){
				if(tmAdministrativeAreaService.validate(t.getId(),t.getAdministrativeAreaCode() , "code")){
					throw new BusinessException("转换行政区域关系Vo到Po时，行政区域编码"+ t.getAdministrativeAreaCode()+"已存在" );
				}
			}else{
				throw new BusinessException("行政区域编码不能为空" );
			}
			
		}else{
			tmAdministrativeAreaEntity  = new TmAdministrativeAreaEntity();

			if(StringUtil.isNotEmpty(t.getAdministrativeAreaName())){
				if(tmAdministrativeAreaService.validate(null,t.getAdministrativeAreaName() , "name")){
					throw new BusinessException("转换行政区域关系Vo到Po时，行政区域"+ t.getAdministrativeAreaName()+"已存在" );
				}
			}else{
				throw new BusinessException("行政区域名称不能为空" );
			}
			if(StringUtil.isNotEmpty(t.getAdministrativeAreaCode())){
				if(tmAdministrativeAreaService.validate(null,t.getAdministrativeAreaCode() , "code")){
					throw new BusinessException("转换行政区域关系Vo到Po时，行政区域编码"+ t.getAdministrativeAreaCode()+"已存在" );
				}
			}else{
				throw new BusinessException("行政区域编码不能为空" );
			}
		}
		
		try {
			MyBeanUtils.copyBeanNotNull2Bean(t, tmAdministrativeAreaEntity);
		} catch (Exception e) {
			e.printStackTrace();
		}
		//装载上级行政区域关系实体
		if(StringUtil.isNotEmpty(t.getParentId())||
				StringUtil.isNotEmpty(t.getParentName())){
			TmAdministrativeAreaEntity busEntity = null;
			if(StringUtil.isNotEmpty(t.getParentId())){
				//导入时parentId为code
				busEntity = tmAdministrativeAreaService.get(TmAdministrativeAreaEntity.class,t.getParentId() );
			}
			if(StringUtil.isNotEmpty(t.getParentName())){
				//导入时parentId为code
				busEntity=tmAdministrativeAreaService.findUniqueByProperty(TmAdministrativeAreaEntity.class, "code", t.getParentName());
			}
			if(busEntity == null){
				throw new BusinessException("转换行政区域关系Vo到Po时，上级行政区域找不到:" +t.getParentId());
			}
			tmAdministrativeAreaEntity.setTmAdministrativeArea(busEntity);
		}
		tmAdministrativeAreaEntity.setEnableStatus(Globals.ZERO);
		return tmAdministrativeAreaEntity;
	}

}
