package com.biz.eisp.mdm.administrativearea.transformer;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.mdm.administrativearea.entity.TmAdministrativeAreaEntity;
import com.biz.eisp.mdm.administrativearea.service.TmAdministrativeAreaService;
import com.biz.eisp.mdm.administrativearea.vo.TmAdministrativeAreaVo;
import com.google.common.base.Function;

/** 类简述.
 * <p>类的详细说明第一行<br>
 * 类的详细说明第二行
 * @author liukai
 * @version v1.0
 */
public class TmAdministrativeAreaVoToTmAdministrativeAreaEntity implements Function <TmAdministrativeAreaVo, TmAdministrativeAreaEntity>{

	private TmAdministrativeAreaService tmAdministrativeAreaService;
	
	public TmAdministrativeAreaVoToTmAdministrativeAreaEntity(TmAdministrativeAreaService tmAdministrativeAreaService) {
		this.tmAdministrativeAreaService = tmAdministrativeAreaService;
	}
	
	
	@Override
	public TmAdministrativeAreaEntity apply(TmAdministrativeAreaVo vo) {
		if(vo == null) {
			return null;
		}
		
		TmAdministrativeAreaEntity tmAdministrativeAreaEntity = null;
		//判断是新增还是修改
		if(StringUtil.isNotEmpty(vo.getId())){
			tmAdministrativeAreaEntity = tmAdministrativeAreaService.get(TmAdministrativeAreaEntity.class, vo.getId());
		}else{
			tmAdministrativeAreaEntity  = new TmAdministrativeAreaEntity();
		}
		
		
		//名称非空与重复验证
		if(StringUtil.isNotEmpty(vo.getAdministrativeAreaName())){
//			if(tmAdministrativeAreaService.validate(vo.getId(), vo.getAdministrativeAreaName() , "administrativeAreaName")){
//				throw new BusinessException("转换行政区域关系Vo到Po时，行政区域"+ vo.getAdministrativeAreaName()+"已存在" );
//			}
		}else{
			throw new BusinessException("行政区域名称不能为空" );
		}
		
		
		//编码非空与重复验证
		if(StringUtil.isNotEmpty(vo.getAdministrativeAreaCode())){
			if(tmAdministrativeAreaService.validate(vo.getId(), vo.getAdministrativeAreaCode() , "administrativeAreaCode")){
				throw new BusinessException("转换行政区域关系Vo到Po时，行政区域编码"+ vo.getAdministrativeAreaCode()+"已存在" );
			}
		}else{
			throw new BusinessException("行政区域编码不能为空" );
		}
		
		try {
			BeanUtils.copyProperties(vo, tmAdministrativeAreaEntity);
			if(StringUtils.isBlank(vo.getId())) {
				tmAdministrativeAreaEntity.setEnableStatus(Globals.ZERO);
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		//装载上级行政区域关系实体
		if(StringUtil.isNotEmpty(vo.getParentId())||
				StringUtil.isNotEmpty(vo.getParentName())){
			TmAdministrativeAreaEntity busEntity = null;
			if(StringUtil.isNotEmpty(vo.getParentId())){
				//导入时parentId为code
				busEntity = tmAdministrativeAreaService.get(TmAdministrativeAreaEntity.class, vo.getParentId() );
			}
			if(StringUtil.isNotEmpty(vo.getParentCode())){
				//导入时parentId为code
				busEntity=tmAdministrativeAreaService.findUniqueByProperty(TmAdministrativeAreaEntity.class, "administrativeAreaCode", vo.getParentCode());
			}
			if(busEntity == null){
				throw new BusinessException("转换行政区域关系Vo到Po时，上级行政区域找不到:" + vo.getParentId());
			}
			tmAdministrativeAreaEntity.setTmAdministrativeArea(busEntity);
		}
		
		return tmAdministrativeAreaEntity;
	}

}
