package com.biz.eisp.mdm.administrativearea.transformer;

import com.biz.eisp.base.common.util.MyBeanUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.mdm.administrativearea.entity.TmAdministrativeAreaEntity;
import com.biz.eisp.mdm.administrativearea.service.TmAdministrativeAreaService;
import com.biz.eisp.mdm.administrativearea.vo.TmAdministrativeAreaExcelVo;
import com.google.common.base.Function;

/**
 * 行政区域管理po转vo
 * @author wuzhujun
 * @version v1.0
 */
public class TmAdministrativeEntityToTmAdministrativeVo implements Function<TmAdministrativeAreaEntity, TmAdministrativeAreaExcelVo>{
	public TmAdministrativeEntityToTmAdministrativeVo(TmAdministrativeAreaService administrativeAreaService){
		super();
		this.administrativeAreaService = administrativeAreaService;
	}
	private TmAdministrativeAreaService administrativeAreaService;
	@Override
	public TmAdministrativeAreaExcelVo apply(TmAdministrativeAreaEntity entity) {
		TmAdministrativeAreaExcelVo tmAdministrativeAreaVo = new TmAdministrativeAreaExcelVo();
		try {
			entity = administrativeAreaService.get(TmAdministrativeAreaEntity.class, entity.getId());
			MyBeanUtils.copyBeanNotNull2Bean(entity,tmAdministrativeAreaVo);
			if(StringUtil.isNotEmpty(entity.getTmAdministrativeArea())){
				tmAdministrativeAreaVo.setParentId(entity.getTmAdministrativeArea().getId());
				tmAdministrativeAreaVo.setParentName(entity.getTmAdministrativeArea().getAdministrativeAreaName());
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return tmAdministrativeAreaVo;
	}
}
