package com.biz.eisp.mdm.authobj.controller;

import com.alibaba.fastjson.JSONObject;
import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.core.web.BaseController;
import com.biz.eisp.mdm.authobj.entity.TmFunAuthEntity;
import com.biz.eisp.mdm.authobj.service.TmFunAuthService;
import com.biz.eisp.mdm.authobj.vo.TmFunctionAuthVo;
import com.biz.eisp.mdm.dict.util.DictUtil;
import com.biz.eisp.mdm.dict.vo.TmDictDataVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;


/** 
 * <p>权限对象Controller</p>
 * @author 肖胜
 * @version v1.0
 */
@Controller
@RequestMapping("/funAuthController")
@SuppressWarnings("deprecation")
public class TmFunAuthController extends BaseController{

	//注入权限对象Service层
	
	@Autowired
	private TmFunAuthService tmFunAuthService;
	
	/**
	 * 加载权限对象设置页面
	 * @param request 对象
	 * @param functionId 菜单主键ID
	 * @return ModelAndView
	 */
	@RequestMapping(value = "funAuth", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView operation(HttpServletRequest request,
			String functionId) {
		request.setAttribute("functionId", functionId);
		
		//页面包含的权限对象集合
		List<TmFunAuthEntity> funAuthList=tmFunAuthService.getTmFunAuthList(functionId);
		request.setAttribute("funAuthList", funAuthList);

		//所有权限对象集合
		List<TmDictDataVo> dictDataList=DictUtil.getDictList(Globals.AuthObj);
		request.setAttribute("dictDataList", dictDataList);
		return new ModelAndView("com/biz/eisp/mdm/funAuth/functionAuth");
	}

	/**
	 * 保存菜单权限对象信息
	 * @param request 请求对象
	 * @param response 响应对象
	 * @param funAuth 菜单记录对象
	 */
	@RequestMapping(value = "saveFunAuth", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public JSONObject saveFunAuth(HttpServletRequest request,
			HttpServletResponse response,TmFunctionAuthVo funAuth){
		try {
			tmFunAuthService.saveFunAuth(funAuth);
		} catch (Exception e) {
			e.printStackTrace();
			this.message="操作失败，请联系开发人员！";
		}
		return returnJson();
	}
}
