package com.biz.eisp.mdm.authobj.entity;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import com.biz.eisp.base.common.identity.IdEntity;
import com.biz.eisp.mdm.role.entity.TmRoleFunctionEntity;

/** 
 * 角色-菜单-权限对象关系.
 * <p>关联数据库表:tm_r_role_func_authobj<br>
 * @author grover
 * @version v1.0
 */
@Entity
@Table(name = "tm_r_role_func_authobj")
@SuppressWarnings("deprecation")
public class TmRoleFuncAuthobjEntity extends IdEntity implements Serializable {
	/**
	 * 序列化id 
	 */
	private static final long serialVersionUID = 1L;
	/**
	 * 权限对象值，对应数据字典中authobj下的值
	 */
	private String authobj;
	/**
	 * 权限对象值，对应数据字典authobj_value下的值
	 */
	private String authobjValue;
	/**
	 * 创建时间
	 */
	private Date createDate;
	/**
	 * 创建用户账号，对应tm_user表中的username字段值
	 */
	private String createName;
	/**
	 * 修改时间
	 */
	private Date updateDate;
	/**
	 * 修改用户账号，对应tm_user表中的username字段值
	 */
	private String updateName;
	/**
	 * 对应菜单角色关系表
	 */
	private TmRoleFunctionEntity tmRoleFunction;
	
	/**
	 *方法: 取得 java.lang.String
	 *@return: java.lang.String 权限对象，对应数据字典authobj下的值
	 */
	@Column(name = "authobj")
	public String getAuthobj() {
		return authobj;
	}
	/**
	 *方法: 设置 java.lang.String
	 *@param: java.lang.String 权限对象，对应数据字典authobj下的值
	 */
	public void setAuthobj(String authobj) {
		this.authobj = authobj;
	}
	/**
	 *方法: 取得 java.lang.String
	 *@return: java.lang.String 权限对象值，对应数据字典authobj_value下的值
	 */
	@Column(name = "authobj_value")
	public String getAuthobjValue() {
		return authobjValue;
	}
	/**
	 *方法: 设置 java.lang.String
	 *@param: java.lang.String 权限对象值，对应数据字典authobj_value下的值
	 */
	public void setAuthobjValue(String authobjValue) {
		this.authobjValue = authobjValue;
	}
	/**
	 *方法: 取得 java.util.Date
	 *@return: java.util.Date 创建时间
	 */
	@Column(name = "create_date")
	public Date getCreateDate() {
		return createDate;
	}
	/**
	 *方法: 设置 java.util.Date
	 *@param: java.util.Date 创建时间
	 */
	public void setCreateDate(Date createDate) {
		this.createDate = createDate;
	}
	/**
	 *方法: 取得 java.lang.String
	 *@return: java.lang.String 创建人
	 */
	@Column(name = "create_name")
	public String getCreateName() {
		return createName;
	}
	/**
	 *方法: 设置 java.lang.String
	 *@param: java.lang.String 创建人
	 */
	public void setCreateName(String createName) {
		this.createName = createName;
	}
	/**
	 *方法: 取得 java.util.Date
	 *@return: java.util.Date 修改时间
	 */
	@Column(name = "update_date")
	public Date getUpdateDate() {
		return updateDate;
	}
	/**
	 *方法: 设置 java.util.Date
	 *@param: java.util.Date 修改时间
	 */
	public void setUpdateDate(Date updateDate) {
		this.updateDate = updateDate;
	}
	/**
	 *方法: 取得 java.lang.String
	 *@return: java.lang.String 修改人
	 */
	@Column(name = "update_name")
	public String getUpdateName() {
		return updateName;
	}
	/**
	 *方法: 设置 java.lang.String
	 *@param: java.lang.String 修改人
	 */
	public void setUpdateName(String updateName) {
		this.updateName = updateName;
	}
	/**
	 *方法: 取得 com.biz.eisp.mdm.role.entity.TmRoleFunctionEntity
	 *@return: com.biz.eisp.mdm.role.entity.TmRoleFunctionEntity 对应菜单角色关系
	 */
	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "role_function_id")
	public TmRoleFunctionEntity getTmRoleFunction() {
		return tmRoleFunction;
	}
	/**
	 *方法: 设置 com.biz.eisp.mdm.role.entity.TmRoleFunctionEntity
	 *@param: com.biz.eisp.mdm.role.entity.TmRoleFunctionEntity 对应菜单角色关系
	 */
	public void setTmRoleFunction(TmRoleFunctionEntity tmRoleFunction) {
		this.tmRoleFunction = tmRoleFunction;
	}
}
