package com.biz.eisp.mdm.authobj.service;

import java.util.List;

import com.biz.eisp.base.core.service.BaseService;
import com.biz.eisp.mdm.authobj.entity.TmFunAuthEntity;
import com.biz.eisp.mdm.authobj.vo.TmFunctionAuthVo;
import com.biz.eisp.mdm.dict.entity.TmDictDataEntity;
import com.biz.eisp.mdm.dict.vo.TmDictDataAuVo;
import com.biz.eisp.mdm.dict.vo.TmDictDataVo;

/** 
 * 菜单权限对象service
 * @author 肖胜
 * @version v1.0
 */
public interface TmFunAuthService extends BaseService{

	/**
	 * 根据菜单id获取权限对象集合
	 * @param functionId 菜单id
	 * @return 权限对象集合
	 */
	public List<TmFunAuthEntity> getTmFunAuthList(String functionId);
	/**
	 * 根据菜单和角色的对应关系获取权限对象集合
	 * @param roleId 角色id
	 * @param funcId 菜单id
	 * @return 权限对象集合
	 */
	public List<TmFunAuthEntity> getTmFunAuthListByRoleFunc(String roleId, String funcId);
	/**
	 * 根据菜单和角色的对应关系获取权限值集合
	 * @param roleId 角色id 
	 * @param funcId 菜单id
	 * @param funcId 菜单authObj
	 * @return 权限值集合
	 */
	public List<TmDictDataAuVo> getTmFunAuthValueByRoleFunc(String roleId, String funcId, String authObj);
	/**
	 * 获取数据字典类authobj
	 * @param dictType 字典类型
	 * @return 数据字典权限对象集合
	 */
	public List<TmDictDataEntity> getTmDictData(String dictTypeValue,String authObj);
	
	/**
	 * 保存菜单权限对象
	 * @param funAuth 权限对象
	 */
	public void saveFunAuth(TmFunctionAuthVo funAuth);
	/**
	 * 保存权限值对象.
	 * @author grover
	 * @param roleId 角色id
	 * @param funcId 菜单id
	 * @param authObj 权限对象
	 * @param authCodes 权限值codes
	 */
	public void saveFunAuthValue(String roleId ,String funcId, String authObj, String authCodes);
}
