package com.biz.eisp.mdm.authobj.service.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import com.biz.eisp.mdm.dict.vo.TmDictDataAuVo;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.mdm.authobj.entity.TmFunAuthEntity;
import com.biz.eisp.mdm.authobj.entity.TmRoleFuncAuthobjEntity;
import com.biz.eisp.mdm.authobj.service.TmFunAuthService;
import com.biz.eisp.mdm.authobj.vo.TmFunctionAuthVo;
import com.biz.eisp.mdm.dict.entity.TmDictDataEntity;
import com.biz.eisp.mdm.dict.transformer.TmDictDataEntityToTmDictDataVo;
import com.biz.eisp.mdm.dict.vo.TmDictDataVo;
import com.biz.eisp.mdm.role.entity.TmRoleFunctionEntity;
import com.google.common.collect.Lists;

/** 
 * 菜单权限对象service实现类
 * @author 肖胜
 * @version v1.0
 */
@SuppressWarnings("deprecation")
@Service("tmFunAuthService")
@Transactional
public class TmFunAuthServiceImpl extends BaseServiceImpl implements TmFunAuthService {

	
	@Override
	public List<TmFunAuthEntity> getTmFunAuthList(String functionId) {
		return this.findByProperty(TmFunAuthEntity.class, "tmFunction.id", functionId);
	}

	@Override
	public List<TmDictDataEntity> getTmDictData(String dictTypeValue,String authObj) {
		String hql="from TmDictDataEntity where tmDictType.dictTypeCode=? and dictCode=?";
		
		List<TmDictDataEntity> dictDataList=findByHql(hql, dictTypeValue,authObj);
		if(dictDataList!=null&&dictDataList.size()>0){
			TmDictDataEntity dictData=dictDataList.get(0);
			return this.findByProperty(TmDictDataEntity.class, "tmDictData.id", dictData.getId());
		}
		return null;
	}

	@Override
	public void saveFunAuth(TmFunctionAuthVo funAuth) {
		String functionId=funAuth.getTmFunction().getId();
		String authobj=funAuth.getAuthobj();
		List<TmFunAuthEntity> authList=this.findByProperty(TmFunAuthEntity.class, "tmFunction.id", functionId);
		this.deleteAllEntity(authList);
		
		if(StringUtil.isNotEmpty(authobj)){
			String[] authObjs=authobj.split(",");
			StringBuffer bufs = new StringBuffer();
			for(String auth:authObjs){
				if(bufs.length()>0){
					bufs.append(",");
				}
				bufs.append("'").append(auth).append("'");
				String hql="from TmFunAuthEntity where tmFunction.id=? and authobj=?";
				TmFunAuthEntity tmFunAuth=this.getUniqueByHql(TmFunAuthEntity.class, hql, functionId,auth);
				//判断是否已取消原有权限对象
				if(tmFunAuth==null||StringUtil.isEmpty(tmFunAuth.getId())){
					tmFunAuth=new TmFunAuthEntity();
					tmFunAuth.setAuthobj(auth);
					tmFunAuth.setTmFunction(funAuth.getTmFunction());
					this.save(tmFunAuth);
				}
			}
			//保存成功后 删除取消对象有的值
			String sql="DELETE FROM TM_R_ROLE_FUNC_AUTHOBJ WHERE ROLE_FUNCTION_ID IN"
					  +" (SELECT TF.ID FROM TM_R_ROLE_FUNCTION TF WHERE TF.FUNCTION_ID=?) AND AUTHOBJ NOT IN(?)";
			executeSql(sql, functionId, bufs.toString());
		}
	}
	
	@Override
	public List<TmFunAuthEntity> getTmFunAuthListByRoleFunc(String roleId,
			String funcId) {
		Set<String> authObjCodes = new HashSet<String>();
		List<TmFunAuthEntity> funAuths = new ArrayList<TmFunAuthEntity>();
		//判断是否已经有数据
		Criterion roleCrt = Restrictions.eq("tmRole.id", roleId);
		Criterion funcCrt = Restrictions.eq("tmFunction.id", funcId);
		List<TmRoleFunctionEntity> roleFuncs =
				findByCriteria(TmRoleFunctionEntity.class, roleCrt, funcCrt);
		if(StringUtil.isNotEmpty(roleFuncs) && roleFuncs.size() > 0){
			TmRoleFunctionEntity tmRoleFunctionEntity = roleFuncs.get(0);
			//查询已经有权限的对象
			List<TmRoleFuncAuthobjEntity> Authobjs = 
					findByProperty(TmRoleFuncAuthobjEntity.class, "tmRoleFunction.id", tmRoleFunctionEntity.getId());
			if(StringUtil.isNotEmpty(Authobjs) && Authobjs.size() > 0){
				for (TmRoleFuncAuthobjEntity authObj : Authobjs) {
					authObjCodes.add(authObj.getAuthobj());
				}
				//查询权限对象
				Criterion authCrt = Restrictions.in("authobj", authObjCodes.toArray());
				funAuths.addAll(findByCriteria(TmFunAuthEntity.class, authCrt));
			}
		}
		return funAuths;
	}

	@Override
	public List<TmDictDataAuVo> getTmFunAuthValueByRoleFunc(String roleId,
			String funcId, String authObj) {
		TmRoleFunctionEntity functionEntity = null;
		//获取所有权限值集合
		List<TmDictDataEntity> dictDatas = getTmDictData(Globals.AuthObj,authObj);
		//获取已经拥有权限的值
		//step1:获取菜单角色实体
		Criterion cr1 = Restrictions.eq("tmRole.id", roleId);
		Criterion cr2 = Restrictions.eq("tmFunction.id", funcId);
		List<TmRoleFunctionEntity> functionEntitys = 
				findByCriteria(TmRoleFunctionEntity.class, cr1, cr2);
		if(!CollectionUtils.isEmpty(functionEntitys)){
			functionEntity = functionEntitys.get(0);
		}
		//step2:获取有权限的值
		String hql="from TmRoleFuncAuthobjEntity where tmRoleFunction.id=? and authobj=?";
		List<TmRoleFuncAuthobjEntity> authobjVlues = 
				findByHql(hql, functionEntity.getId(), authObj);
		//转换
		List<TmDictDataAuVo> dataVos = Lists.transform(dictDatas, new TmDictDataEntityToTmDictDataVo(authobjVlues));
		return dataVos;
	}

	@Override
	public void saveFunAuthValue(String roleId, String funcId, String authObj,String authCodes) {
		String hql= "from TmRoleFunctionEntity where tmRole.id=? and tmFunction.id=?";
		List<TmRoleFunctionEntity> roleFuncs = findByHql(hql, roleId, funcId);
		if(!CollectionUtils.isEmpty(roleFuncs) &&roleFuncs.size() > 0){
			TmRoleFunctionEntity roleFunctionEntity = roleFuncs.get(0);
			//保存之前先删除原有关联数据
			String sql = "delete from tm_r_role_func_authobj where role_function_id=? and authobj=?";
			executeSql(sql, roleFunctionEntity.getId(),authObj);
			TmRoleFuncAuthobjEntity authobjEntity = null;
			if(StringUtil.isNotEmpty(authCodes)){
				for (String authCode : authCodes.split(",")) {
					authobjEntity = new TmRoleFuncAuthobjEntity();
					authobjEntity.setTmRoleFunction(roleFunctionEntity);
					authobjEntity.setAuthobj(authObj);
					authobjEntity.setAuthobjValue(authCode);
					save(authobjEntity);
				}
			}
		}
		
		
	}
}
